# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ReplicationStatus(Model):
    """This is the replication status of the gallery Image Version.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar aggregated_state: This is the aggregated replication status based on
     all the regional replication status flags. Possible values include:
     'Unknown', 'InProgress', 'Completed', 'Failed'
    :vartype aggregated_state: str or
     ~azure.mgmt.compute.v2018_06_01.models.AggregatedReplicationState
    :ivar summary: This is a summary of replication status for each region.
    :vartype summary:
     list[~azure.mgmt.compute.v2018_06_01.models.RegionalReplicationStatus]
    """

    _validation = {
        'aggregated_state': {'readonly': True},
        'summary': {'readonly': True},
    }

    _attribute_map = {
        'aggregated_state': {'key': 'aggregatedState', 'type': 'str'},
        'summary': {'key': 'summary', 'type': '[RegionalReplicationStatus]'},
    }

    def __init__(self, **kwargs):
        super(ReplicationStatus, self).__init__(**kwargs)
        self.aggregated_state = None
        self.summary = None
