# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FileServerCreateParameters(Model):
    """Parameters supplied to the Create operation.

    All required parameters must be populated in order to send to Azure.

    :param vm_size: Required. The size of the virtual machine of the file
     server. For information about available VM sizes for fileservers from the
     Virtual Machines Marketplace, see Sizes for Virtual Machines (Linux).
    :type vm_size: str
    :param ssh_configuration: Required. SSH configuration for the file server.
    :type ssh_configuration: ~azure.mgmt.batchai.models.SshConfiguration
    :param data_disks: Required. Settings for the data disk which would be
     created for the file server.
    :type data_disks: ~azure.mgmt.batchai.models.DataDisks
    :param subnet: Specifies the identifier of the subnet.
    :type subnet: ~azure.mgmt.batchai.models.ResourceId
    """

    _validation = {
        'vm_size': {'required': True},
        'ssh_configuration': {'required': True},
        'data_disks': {'required': True},
    }

    _attribute_map = {
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'ssh_configuration': {'key': 'properties.sshConfiguration', 'type': 'SshConfiguration'},
        'data_disks': {'key': 'properties.dataDisks', 'type': 'DataDisks'},
        'subnet': {'key': 'properties.subnet', 'type': 'ResourceId'},
    }

    def __init__(self, **kwargs):
        super(FileServerCreateParameters, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)
        self.ssh_configuration = kwargs.get('ssh_configuration', None)
        self.data_disks = kwargs.get('data_disks', None)
        self.subnet = kwargs.get('subnet', None)
