# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TrainingStatus(Model):
    """Training status object.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Training status: notstarted, running, succeeded,
     failed. If the training process is waiting to perform, the status is
     notstarted. If the training is ongoing, the status is running. Status
     succeed means this person group or large person group is ready for Face -
     Identify, or this large face list is ready for Face - Find Similar. Status
     failed is often caused by no person or no persisted face exist in the
     person group or large person group, or no persisted face exist in the
     large face list. Possible values include: 'nonstarted', 'running',
     'succeeded', 'failed'
    :type status: str or
     ~azure.cognitiveservices.vision.face.models.TrainingStatusType
    :param created: Required. A combined UTC date and time string that
     describes the created time of the person group, large person group or
     large face list.
    :type created: datetime
    :param last_action: A combined UTC date and time string that describes the
     last modify time of the person group, large person group or large face
     list, could be null value when the group is not successfully trained.
    :type last_action: datetime
    :param last_successful_training: A combined UTC date and time string that
     describes the last successful training time of the person group, large
     person group or large face list.
    :type last_successful_training: datetime
    :param message: Show failure message when training failed (omitted when
     training succeed).
    :type message: str
    """

    _validation = {
        'status': {'required': True},
        'created': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'TrainingStatusType'},
        'created': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_action': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'last_successful_training': {'key': 'lastSuccessfulTrainingDateTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, status, created, last_action=None, last_successful_training=None, message: str=None, **kwargs) -> None:
        super(TrainingStatus, self).__init__(**kwargs)
        self.status = status
        self.created = created
        self.last_action = last_action
        self.last_successful_training = last_successful_training
        self.message = message
