# -*- coding: utf-8 -*-
info = {
    "name": "el",
    "date_order": "DMY",
    "january": [
        "ιανουάριος",
        "ιαν",
        "ιανουαρίου"
    ],
    "february": [
        "φεβρουάριος",
        "φεβ",
        "φεβρουαρίου"
    ],
    "march": [
        "μάρτιος",
        "μάρ",
        "μαρτίου",
        "μαρ"
    ],
    "april": [
        "απρίλιος",
        "απρ",
        "απριλίου"
    ],
    "may": [
        "μάιος",
        "μάι",
        "μαΐου",
        "μαΐ"
    ],
    "june": [
        "ιούνιος",
        "ιούν",
        "ιουνίου",
        "ιουν"
    ],
    "july": [
        "ιούλιος",
        "ιούλ",
        "ιουλίου",
        "ιουλ"
    ],
    "august": [
        "αύγουστος",
        "αύγ",
        "αυγούστου",
        "αυγ"
    ],
    "september": [
        "σεπτέμβριος",
        "σεπ",
        "σεπτεμβρίου"
    ],
    "october": [
        "οκτώβριος",
        "οκτ",
        "οκτωβρίου"
    ],
    "november": [
        "νοέμβριος",
        "νοέ",
        "νοεμβρίου",
        "νοε"
    ],
    "december": [
        "δεκέμβριος",
        "δεκ",
        "δεκεμβρίου"
    ],
    "monday": [
        "δευτέρα",
        "δευ"
    ],
    "tuesday": [
        "τρίτη",
        "τρί"
    ],
    "wednesday": [
        "τετάρτη",
        "τετ"
    ],
    "thursday": [
        "πέμπτη",
        "πέμ"
    ],
    "friday": [
        "παρασκευή",
        "παρ"
    ],
    "saturday": [
        "σάββατο",
        "σάβ"
    ],
    "sunday": [
        "κυριακή",
        "κυρ"
    ],
    "am": [
        "πμ"
    ],
    "pm": [
        "μμ"
    ],
    "year": [
        "έτος",
        "έτ"
    ],
    "month": [
        "μήνας",
        "μήν"
    ],
    "week": [
        "εβδομάδα",
        "εβδ"
    ],
    "day": [
        "ημέρα"
    ],
    "hour": [
        "ώρα",
        "ώρ",
        "ώ"
    ],
    "minute": [
        "λεπτό",
        "λεπ",
        "λ"
    ],
    "second": [
        "δευτερόλεπτο",
        "δευτ",
        "δ"
    ],
    "relative-type": {
        "1 year ago": [
            "πέρσι"
        ],
        "0 year ago": [
            "φέτος"
        ],
        "in 1 year": [
            "επόμενο έτος"
        ],
        "1 month ago": [
            "προηγούμενος μήνας"
        ],
        "0 month ago": [
            "τρέχων μήνας"
        ],
        "in 1 month": [
            "επόμενος μήνας"
        ],
        "1 week ago": [
            "προηγούμενη εβδομάδα"
        ],
        "0 week ago": [
            "αυτήν την εβδομάδα"
        ],
        "in 1 week": [
            "επόμενη εβδομάδα"
        ],
        "1 day ago": [
            "χθες"
        ],
        "0 day ago": [
            "σήμερα"
        ],
        "in 1 day": [
            "αύριο"
        ],
        "0 hour ago": [
            "αυτήν την ώρα"
        ],
        "0 minute ago": [
            "αυτό το λεπτό"
        ],
        "0 second ago": [
            "τώρα"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "σε (\\d+) έτος",
            "σε (\\d+) έτη"
        ],
        "\\1 year ago": [
            "πριν από (\\d+) έτος",
            "πριν από (\\d+) έτη",
            "(\\d+) έτος πριν",
            "(\\d+) έτη πριν"
        ],
        "in \\1 month": [
            "σε (\\d+) μήνα",
            "σε (\\d+) μήνες",
            "σε (\\d+) μ"
        ],
        "\\1 month ago": [
            "πριν από (\\d+) μήνα",
            "πριν από (\\d+) μήνες",
            "(\\d+) μ πριν"
        ],
        "in \\1 week": [
            "σε (\\d+) εβδομάδα",
            "σε (\\d+) εβδομάδες",
            "σε (\\d+) εβδ"
        ],
        "\\1 week ago": [
            "πριν από (\\d+) εβδομάδα",
            "πριν από (\\d+) εβδομάδες",
            "πριν από (\\d+) εβδ",
            "(\\d+) εβδ πριν"
        ],
        "in \\1 day": [
            "σε (\\d+) ημέρα",
            "σε (\\d+) ημέρες",
            "σε (\\d+) ημ"
        ],
        "\\1 day ago": [
            "πριν από (\\d+) ημέρα",
            "πριν από (\\d+) ημέρες",
            "(\\d+) ημ πριν"
        ],
        "in \\1 hour": [
            "σε (\\d+) ώρα",
            "σε (\\d+) ώρες",
            "σε (\\d+) ώρ",
            "σε (\\d+) ώ"
        ],
        "\\1 hour ago": [
            "πριν από (\\d+) ώρα",
            "πριν από (\\d+) ώρες",
            "πριν από (\\d+) ώρ",
            "(\\d+) ώ πριν"
        ],
        "in \\1 minute": [
            "σε (\\d+) λεπτό",
            "σε (\\d+) λεπτά",
            "σε (\\d+) λεπ",
            "σε (\\d+) λ"
        ],
        "\\1 minute ago": [
            "πριν από (\\d+) λεπτό",
            "πριν από (\\d+) λεπτά",
            "πριν από (\\d+) λεπ",
            "(\\d+) λ πριν"
        ],
        "in \\1 second": [
            "σε (\\d+) δευτερόλεπτο",
            "σε (\\d+) δευτερόλεπτα",
            "σε (\\d+) δευτ",
            "σε (\\d+) δ"
        ],
        "\\1 second ago": [
            "πριν από (\\d+) δευτερόλεπτο",
            "πριν από (\\d+) δευτερόλεπτα",
            "πριν από (\\d+) δευτ",
            "(\\d+) δ πριν"
        ]
    },
    "locale_specific": {
        "el-CY": {
            "name": "el-CY"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}