#
# PySNMP MIB module APM-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/APM-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:04:57 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueRangeConstraint, SingleValueConstraint, ConstraintsIntersection, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueRangeConstraint", "SingleValueConstraint", "ConstraintsIntersection", "ValueSizeConstraint")
( OwnerString, rmon, ) = mibBuilder.importSymbols("RMON-MIB", "OwnerString", "rmon")
( protocolDirLocalIndex, ) = mibBuilder.importSymbols("RMON2-MIB", "protocolDirLocalIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( Gauge32, Counter32, IpAddress, Counter64, ModuleIdentity, NotificationType, ObjectIdentity, Integer32, Bits, MibIdentifier, Unsigned32, TimeTicks, iso, MibScalar, MibTable, MibTableRow, MibTableColumn, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Gauge32", "Counter32", "IpAddress", "Counter64", "ModuleIdentity", "NotificationType", "ObjectIdentity", "Integer32", "Bits", "MibIdentifier", "Unsigned32", "TimeTicks", "iso", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn")
( DisplayString, TimeInterval, TruthValue, TimeStamp, RowStatus, StorageType, TextualConvention, DateAndTime, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TimeInterval", "TruthValue", "TimeStamp", "RowStatus", "StorageType", "TextualConvention", "DateAndTime")
apm = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 23)).setRevisions(("2004-02-19 00:00",))
if mibBuilder.loadTexts: apm.setLastUpdated('200402190000Z')
if mibBuilder.loadTexts: apm.setOrganization('IETF RMON MIB Working Group')
if mibBuilder.loadTexts: apm.setContactInfo('Author:\n                     Steve Waldbusser\n\n             Phone:  +1-650-948-6500\n             Fax :   +1-650-745-0671\n             Email:  waldbusser@nextbeacon.com\n\n         Working Group Chair:\n                     Andy Bierman\n                     Cisco Systems, Inc.\n             Postal: 170 West Tasman Drive\n                     San Jose, CA USA 95134\n                Tel: +1 408 527-3711\n             E-mail: abierman@cisco.com\n\n         Working Group Mailing List: <rmonmib@ietf.org>\n         To subscribe send email to: <rmonmib-request@ietf.org>\n        ')
if mibBuilder.loadTexts: apm.setDescription('The MIB module for measuring application performance\n        as experienced by end-users.\n\n        Copyright (C) The Internet Society (2004). This version of\n        this MIB module is part of RFC 3729; see the RFC itself for\n        full legal notices.')
apmMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 1))
apmConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 2))
apmCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 2, 1))
apmGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 2, 2))
class AppLocalIndex(Unsigned32, TextualConvention):
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(1,2147483647)

class ProtocolDirNetworkAddress(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)

class DataSourceOrZero(ObjectIdentifier, TextualConvention):
    pass

class RmonClientID(Unsigned32, TextualConvention):
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,4294967295)

class TransactionAggregationType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))
    namedValues = NamedValues(("flows", 1), ("clients", 2), ("servers", 3), ("applications", 4),)

apmAppDirTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 1), )
if mibBuilder.loadTexts: apmAppDirTable.setDescription("The APM MIB directory of applications and application\n        verbs. The agent will populate this table with all\n        applications/verbs of any responsivenessType it has the\n        capability to monitor. Since the agent populates this table\n        with every entry it has the capability to monitor, the\n        entries in this table are read-write, allowing the management\n        station to modify parameters in this table but not to add new\n        entries or delete entries (however, entries may be\n        disabled). If new entries are added to the apmHttpFilterTable\n        or the apmUserDefinedAppTable, the agent will add the\n        corresponding entries to this table.\n\n        It is an implementation-dependent matter as to how the agent\n        sets these default parameters. For example, it may leave\n        certain entries in this table 'off(0)' if the agent developer\n\n        believes that combination will be infrequently used, allowing\n        a manager that needs that capability to set it to 'on(1)'.\n\n        Some applications are registered in the RMON2 protocol\n        directory and some are registered in other tables in this\n        MIB Module. Regardless of where an application is originally\n        registered, it is assigned an AppLocalIndex value that is the\n        primary index for this table.\n\n        The contents of this table affect all reports and exceptions\n        generated by this agent. Accordingly, modification of this\n        table should be performed by a manager acting in the role of\n        administrator. In particular, management software should not\n        require or enforce particular configuration of this table - it\n        should reflect the preferences of the site administrator, not\n        the software author. As a practical matter, this requires\n        management software to allow the administrator to configure\n        the values it will use so that it can be adapted to the site\n        policy.")
apmAppDirEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1), ).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"))
if mibBuilder.loadTexts: apmAppDirEntry.setDescription('The APM MIB directory of applications and application\n        verbs. An entry will exist in this table for all applications\n        for which application performance measurement is supported.')
apmAppDirAppLocalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 1), AppLocalIndex())
if mibBuilder.loadTexts: apmAppDirAppLocalIndex.setDescription('The AppLocalIndex assigned for this application Directory\n        entry.')
apmAppDirResponsivenessType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("transactionOriented", 1), ("throughputOriented", 2), ("streamingOriented", 3),)))
if mibBuilder.loadTexts: apmAppDirResponsivenessType.setDescription("This object describes and configures the agent's support for\n        application performance measurement for this application.\n        There are 3 types of measurements for different types of\n        applications:\n\n        Transaction-Oriented applications have a fairly constant\n        workload to perform for all transactions. The responsiveness\n        metric for transaction-oriented applications is application\n        response time (from first request to final delivery of\n        service) and is measured in milliseconds. This is\n        commonly referred to as end-user response time.\n\n        Throughput-Oriented applications have widely varying workloads\n        based on the nature of the client request. In particular,\n        throughput-oriented applications vary widely in the amount of\n        data that must be transported to satisfy the request. The\n        responsiveness metric for throughput-oriented applications is\n        kilobits per second.\n\n        Streaming-Oriented applications deliver data at a constant\n        metered rate of speed regardless of the responsiveness of the\n        networking and computing infrastructure. This constant rate of\n        speed is generally specified to be below (sometimes well\n        below) the nominal capability of the infrastructure. However,\n        when the infrastructures cannot deliver data at this speed,\n        interruption of service or degradation of service can\n        result. The responsiveness metric for streaming-oriented\n        applications is the ratio of time that the service is degraded\n        or interrupted to the total service time. This metric is\n        measured in parts per million.\n\n        Note that for some applications, measuring more than one\n        responsiveness type may be interesting. For agents that wish\n\n        to support more than one measurement for a application, they\n        will populate this table with multiple entries for that\n        application, one for each type.")
apmAppDirConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("off", 1), ("on", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirConfig.setDescription('This object describes and configures support for application\n        performance measurement for this application.\n\n        If the value of this object is on(2), the agent supports\n        measurement of application performance metrics for this\n        application and is configured to measure such metrics for all\n        APM MIB functions and all interfaces.  If the value of this\n        object is off(1), the agent supports measurement of\n        application performance for this application but is configured\n        to not measure these metrics for any APM MIB functions or\n        interfaces.  Whenever this value changes from on(2) to off(1),\n        the agent shall delete all related entries in all tables in\n        this MIB Module.\n\n        The value of this object must persist across reboots.')
apmAppDirResponsivenessBoundary1 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary1.setDescription('The boundary value between bucket1 and bucket 2. If this\n        value is modified, all entries in the apmReportTable must be\n        deleted by the agent.\n\n        The value of this object must persist across reboots.')
apmAppDirResponsivenessBoundary2 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 5), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary2.setDescription('The boundary value between bucket2 and bucket 3. If this\n\n        value is modified, all entries in the apmReportTable must be\n        deleted by the agent.\n\n        The value of this object must persist across reboots.')
apmAppDirResponsivenessBoundary3 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 6), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary3.setDescription('The boundary value between bucket3 and bucket 4. If this\n        value is modified, all entries in the apmReportTable must be\n        deleted by the agent.\n\n        The value of this object must persist across reboots.')
apmAppDirResponsivenessBoundary4 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 7), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary4.setDescription('The boundary value between bucket4 and bucket 5. If this\n        value is modified, all entries in the apmReportTable must be\n        deleted by the agent.\n\n        The value of this object must persist across reboots.')
apmAppDirResponsivenessBoundary5 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 8), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary5.setDescription('The boundary value between bucket5 and bucket 6. If this\n        value is modified, all entries in the apmReportTable must be\n        deleted by the agent.\n\n        The value of this object must persist across reboots.')
apmAppDirResponsivenessBoundary6 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 9), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary6.setDescription('The boundary value between bucket6 and bucket 7. If this\n\n        value is modified, all entries in the apmReportTable must be\n        deleted by the agent.\n\n        The value of this object must persist across reboots.')
apmBucketBoundaryLastChange = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmBucketBoundaryLastChange.setDescription('The value of sysUpTime the last time that any bucket boundary\n        in any appDirEntry was changed. This object can help to\n        determine if two managers are both trying to enforce different\n        configurations of this table.')
apmAppDirID = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 3), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirID.setDescription("This object allows managers to avoid downloading application\n        directory information when the directory is set to a known\n        (usually fixed) configuration.\n\n        If the value of this object isn't 0.0, it signifies\n        that the entire contents of the apmAppDirTable,\n        apmHttpFilterTable, apmUserDefinedAppTable and\n        protocolDirTable are equal to a known state identified\n        by the value of this object. If a manager recognizes this\n        value as identifying a directory configuration it has a local\n        copy of, it may use this local copy rather than downloading\n        these tables. Note that it may have downloaded this local copy\n        (and the ID) from another agent and used this copy for all\n        other agents that advertised the same ID.\n\n        If an agent recognizes that the entire contents of the\n        apmAppDirTable, apmHttpFilterTable,\n        apmUserDefinedAppTable and protocolDirTable are equal to\n        a known state to which an ID has been assigned, it should set\n        this object to that ID.\n\n        In many cases when this feature is used, the application\n        directory information will be in read-only memory and thus the\n        tables may not be modified via SNMP requests. In the event\n\n        that the tables are writable and a modification is made, the\n        agent is responsible for setting this object to 0.0 if it\n        cannot determine that the state is equal to a known state.\n\n        An agent is not obligated to recognize and advertise all such\n        registered states as it may not have knowledge of all states.\n        Thus, a manager may encounter agents whose DirectoryID value\n        is 0.0 even though the contents of the directory were equal to\n        a registered state.\n\n        Note that the contents of those tables includes the\n        protocolDirLocalIndex and appLocalIndex values. In other\n        words, these values can't be assigned randomly on each agent,\n        but must be equal to values that are part of the known\n        state. While it is possible for a manager to download\n        application directory details using SNMP and to set the\n        appropriate directoryID, the manager would need to have some\n        scheme to ensure consistent values of LocalIndex variables\n        from agent to agent. Such schemes are outside the scope of\n        this specification.\n\n        Application directory registrations are unique within an\n        administrative domain.\n\n        Typically these registrations will be made by an agent\n        software developer who will set the application directory\n        tables to a read-only state and assign a DirectoryID to that\n        state. Thus, all agents running this software would share the\n        same DirectoryID. As the application directory might change\n        from one software release to the next, the developer may\n        register different DirectoryID's for each software release.\n\n        A customer could also create a site-wide application directory\n        configuration and assign a DirectoryID to that configuration\n        as long as consistent values of LocalIndex variables can be\n        ensured.\n\n        The value of this object must persist across reboots.")
apmHttpFilterTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 4), )
if mibBuilder.loadTexts: apmHttpFilterTable.setDescription('A table that creates virtual applications which measure the\n        performance of certain web pages or sets of web pages.\n\n        When an entry is added to this table, the agent will\n        automatically create one or more entries in the\n        apmAppDirTable (one for each responsivenessType it is\n        capable of measuring).\n\n        Note that when entries exist in this table some HTTP\n        transactions will be summarized twice: in applications\n        represented here as well as the HTTP application. If entries\n        in this table overlap, these transactions may be summarized\n        additional times.\n\n        The contents of this table affect all reports and exceptions\n        generated by this agent. Accordingly, modification of this\n        table should be performed by a manager acting in the role of\n        administrator. In particular, management software should not\n        require or enforce particular configuration of this table - it\n        should reflect the preferences of the site administrator, not\n        the software author.')
apmHttpFilterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1), ).setIndexNames((0, "APM-MIB", "apmHttpFilterIndex"))
if mibBuilder.loadTexts: apmHttpFilterEntry.setDescription('A virtual application which measure the performance of certain\n        web pages or sets of web pages.')
apmHttpFilterIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: apmHttpFilterIndex.setDescription('An index that uniquely identifies an entry in the\n        apmHttpFilterTable.')
apmHttpFilterAppLocalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 2), AppLocalIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmHttpFilterAppLocalIndex.setDescription('The AppLocalIndex that represents HTTP transactions\n        that match this entry.\n\n        This object is read-only. A value is created by the agent from\n        an unused AppLocalIndex value when this apmHttpFilterEntry is\n        created.')
apmHttpFilterServerProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterServerProtocol.setDescription('The protocolDirLocalIndex value of the network level protocol\n        of the apmHttpFilterServerAddress.')
apmHttpFilterServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 4), ProtocolDirNetworkAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterServerAddress.setDescription("This entry will only represent transactions coming from the\n        network address specified in this object.\n\n\n        This is represented as an octet string with\n        specific semantics and length as identified\n        by the associated apmHttpFilterServerProtocol object.\n\n        If this object is the zero-length string, then this entry will\n        match one of the addresses represented by the 'host' component\n        of the associated apmHttpFilterURLPath object, where the\n        format if a URL [9] is\n        http://<host>:<port>/<path>?<searchpart>.")
apmHttpFilterURLPath = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterURLPath.setDescription('This entry will only represent HTTP transactions\n        where the URL path component in the request matches this\n        value. This value represents the requested path regardless of\n        any substitution that the server might perform.\n\n        Prior to the matching, the URL is stripped of any server\n        address or DNS name and consists solely of the path name on\n        that server.\n\n        If the length of this object is zero, then this entry will\n        match if the associated apmHttpFilterServerAddress match. If\n        the length of that object is also zero, then this entry will\n        match nothing.\n\n        The value of the associated apmHttpFilterMatchType dictates\n        the type of matching that will be attempted.')
apmHttpFilterMatchType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("exact", 1), ("stripTrailingSlash", 2), ("prefix", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterMatchType.setDescription("The matching algorithm used to compare the URL pathname.\n\n        If the value is exact(1), then the pathname component will be\n        compared with the associated apmHttpFilterURLPath and\n        will only be associated with this entry if it matches exactly.\n\n        If the value is stripTrailingSlash(2), then the pathname\n        component will be compared with the associated\n        apmHttpFilterURLPath and will only be associated with this\n        entry if it matches exactly or if the pathname ends with a '/'\n        symbol and matches apmHttpFilterURLPath if the '/' symbol is\n        removed from the pathname. This option exists for those paths\n        where an optional trailing slash is possible but for which a\n        prefix match would be too broad.\n\n        If the value is prefix(3), then the pathname component will be\n        compared with the associated apmHttpFilterURLPath and will\n        only be associated with this entry if the beginning of the\n        pathname matches every octet of this value. Octets that extend\n        beyond the length of this value are ignored.")
apmHttpFilterOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 7), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterOwner.setDescription('The entity that configured this entry and is\n        therefore using the resources assigned to it.')
apmHttpFilterStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 8), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterStorageType.setDescription("The storage type of this apmHttpFilterEntry. If the value of\n        this object is 'permanent', no objects in this row need to be\n        writable.")
apmHttpFilterRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterRowStatus.setDescription("The status of this apmHttpFilterEntry. No objects in this row\n        may be modified while the row's status is 'active'.")
apmHttpIgnoreUnregisteredURLs = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmHttpIgnoreUnregisteredURLs.setDescription('When true, APM measurements of HTTP transactions will only\n        measure transactions relating to URLs that match a filter in\n        the apmHttpFilterTable. Thus, measurements for the HTTP\n        application will present aggregated statistics for\n        URL-matching HTTP transactions and measurements for the HTTP\n        GET application verb will present aggregated statistics for\n        URL-matching HTTP GET transactions.\n\n        This will be used in environments that wish to monitor only\n        targeted URLs and to ignore large volumes of internet web\n        browsing traffic.\n\n        This object affects all APM reports and exceptions generated\n        by this agent. Accordingly, modification of this object should\n        be performed by a manager acting in the role of\n        administrator. In particular, management software should not\n        require or enforce particular configuration of this object -\n        it should reflect the preferences of the site administrator,\n        not the software author.\n\n        The value of this object must persist across reboots.')
apmHttp4xxIsFailure = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 6), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmHttp4xxIsFailure.setDescription("When true, this agent will recognize HTTP errors in the range\n        of 400 through 499 and will treat them as unavailable\n        transactions. When false or when this object isn't supported,\n        they will be treated as successful transactions.\n\n        This object allows such error pages to be tracked at the\n        possible expense of having user typos treated as poor service\n        on the part of the web server.\n\n        This object affects all reports and exceptions generated by\n        this agent. Accordingly, modification of this object should be\n        performed by a manager acting in the role of administrator. In\n        particular, management software should not require or enforce\n        particular configuration of this object - it should reflect\n        the preferences of the site administrator, not the software\n        author.\n\n        The value of this object must persist across reboots.")
apmUserDefinedAppTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 7), )
if mibBuilder.loadTexts: apmUserDefinedAppTable.setDescription('A table that advertises user-defined applications that the\n        agent is measuring.\n\n        The agent will automatically create one or more entries in the\n        apmAppDirTable (one for each responsivenessType it is\n        capable of measuring) for each entry in this table.\n\n        Note that when entries exist in this table some\n        transactions can be summarized more than once if there is\n        overlap between applications defined here and applications\n        defined in the protocol directory or in the httpFilter table.')
apmUserDefinedAppEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 7, 1), ).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"))
if mibBuilder.loadTexts: apmUserDefinedAppEntry.setDescription('A user-defined application that the agent is measuring, along\n        with its AppLocalIndex assignment.\n\n        The apmAppDirAppLocalIndex value in the index identifies\n        the agent-assigned AppLocalIndex value for this user-defined\n        application.')
apmUserDefinedAppParentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 7, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmUserDefinedAppParentIndex.setDescription('The protocolDirLocalIndex value of the highest-layer\n        protocol defined in the protocolDirTable that this\n        application is a child of.')
apmUserDefinedAppApplication = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 7, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmUserDefinedAppApplication.setDescription('A human readable descriptive tag for this application.')
apmNameTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 8), )
if mibBuilder.loadTexts: apmNameTable.setDescription("A client machine may have multiple addresses during a period\n        of monitoring. The apmNameTable assigns a long-lived\n        identifier to a client and records what addresses were\n        assigned to that client for periods of time. Various\n        implementation techniques exist for tracking this mapping but\n        if an agent is unable to track client address mappings, it may\n        map client identifiers to client addresses rather than to\n        distinct client machines.\n\n        A particular apmNameClientID should be a constant attribute of\n        a particular client. When available, the agent may also record\n        the machine name and/or user name which may be valuable for\n        displaying to humans. The apmNameMachineName and\n        apmNameUserName are relatively constant, changing only if\n        these attributes actually change on the client.\n\n        The agent will store a historical log of these entries, aging\n        out old entries as the log becomes too large. Since this table\n        contains information vital to the interpretation of other\n        tables (e.g., the apmReportTable), the agent should ensure that\n\n        the log doesn't age out entries that would be referenced by\n        data in those tables.\n\n        Note that an entry for a clientID is active from its\n        StartTime until the StartTime of another entry (for the same\n        clientID) that supersedes it, or 'now' if none supersede\n        it. Therefore, if a clientID only has a single entry, it is by\n        definition very new and should never be aged out. No entry for\n        a clientID should be aged out unless it has been updated by a\n        new entry for the client (i.e., with an updated address) and\n        only if the new entry is 'old' enough.\n\n        To determine how old is old enough, compute the maximum value\n        of Interval * (NumReports + 1) of all entries in the\n        apmReportControlTable (the '+ 1' is to allow a reasonable\n        period of time for the report to be downloaded). Then take the\n        larger of this value and the age in seconds of the oldest\n        entry in the current transaction table. If an entry for a\n        clientID is superseded by another entry whose StartTime is\n        more than this many seconds ago, then the older entry may be\n        deleted.")
apmNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1), ).setIndexNames((0, "APM-MIB", "apmNameClientID"), (0, "RMON2-MIB", "protocolDirLocalIndex"), (0, "APM-MIB", "apmNameClientAddress"), (0, "APM-MIB", "apmNameMappingStartTime"))
if mibBuilder.loadTexts: apmNameEntry.setDescription('An entry in the APM name table. An entry exists for each\n        period of time that a client has been associated with a\n        particular address.\n\n        The protocolDirLocalIndex value in the index identifies\n        the network layer protocol for the ClientAddress for this\n        entry.\n\n        Note that some combinations of index values may result in an\n        index that exceeds 128 sub-identifiers in length which exceeds\n        the maximum for the SNMP protocol. Implementations should take\n        care to avoid such combinations.')
apmNameClientID = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 1), RmonClientID())
if mibBuilder.loadTexts: apmNameClientID.setDescription('A unique ID assigned to the machine represented by this\n         mapping. This ID is assigned by the agent using an\n         implementation-specific algorithm.')
apmNameClientAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 2), ProtocolDirNetworkAddress().subtype(subtypeSpec=ValueSizeConstraint(1,255)))
if mibBuilder.loadTexts: apmNameClientAddress.setDescription("The network client address for this client when this mapping\n        was active.\n\n        This is represented as an octet string with specific semantics\n        and length as identified by the protocolDirLocalIndex\n        component of the index. This object may not be the zero length\n        string.\n\n        Since this object is an index variable, it is encoded in the\n        index according to the index encoding rules.  For example, if\n        the protocolDirLocalIndex component of the index indicates an\n        encapsulation of ip, this object is encoded as a length octet\n        of 4, followed by the 4 octets of the ip address, in network\n        byte order. Care should be taken to avoid values of this\n        object that, in conjunction with the other index variables,\n        would result in an index longer than SNMP's maximum of 128\n        subidentifiers.")
apmNameMappingStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 3), DateAndTime())
if mibBuilder.loadTexts: apmNameMappingStartTime.setDescription('The time that the agent first discovered this mapping\n        as active.')
apmNameMachineName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 4), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmNameMachineName.setDescription('The human readable name of the client machine.\n\n        If the client has no machine name or the agent is\n        unable to learn the machine name, this object will be\n        a zero-length string.')
apmNameUserName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmNameUserName.setDescription("The human readable name of a human user using the client\n        machine. If more than one user name are available\n        simultaneously, it is an implementation-dependent matter as to\n        which is used here. However, if the user name changes, this\n        object should change to reflect that change.\n\n        Non-human user names like 'root' or 'administrator' aren't\n        intended as values for this object. If the client has no\n        recorded user name or the agent is unable to learn a user\n        name, this object will be a zero-length string.")
apmReportControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 9), )
if mibBuilder.loadTexts: apmReportControlTable.setDescription('Parameters that control the creation of a set of reports that\n        aggregate application performance.')
apmReportControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1), ).setIndexNames((0, "APM-MIB", "apmReportControlIndex"))
if mibBuilder.loadTexts: apmReportControlEntry.setDescription('A conceptual row in the apmReportControlTable.\n\n        An example of the indexing of this table is\n\n        apmReportControlInterval.3')
apmReportControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: apmReportControlIndex.setDescription('An index that uniquely identifies an entry in the\n        apmReportControlTable.  Each such entry defines a unique\n        report whose results are placed in the apmReportTable on\n        behalf of this apmReportControlEntry.')
apmReportControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 2), DataSourceOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlDataSource.setDescription("The source of the data for APM Reports generated on\n        behalf of this apmReportControlEntry.\n\n        If the measurement is being performed by a probe, this should\n        be set to interface or port where data was received for\n        analysis. If the measurement isn't being performed by a probe,\n        this should be set to the primary interface over which the\n        measurement is being performed. If the measurement isn't being\n        performed by a probe and there is no primary interface or this\n\n        information isn't known, this object should be set to 0.0.\n\n        This object may not be modified if the associated\n        apmReportControlStatus object is equal to active(1).")
apmReportControlAggregationType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 3), TransactionAggregationType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlAggregationType.setDescription('The type of aggregation being performed for this set of\n        reports.\n\n        The metrics for a single transaction are the responsiveness of\n        the transaction and whether the transaction succeeded (a\n        boolean). When such metrics are aggregated in this MIB Module,\n        these metrics are replaced by averages and distributions of\n        responsiveness and availability. The metrics describing\n        aggregates are constant no matter which type of aggregation is\n        being performed. These metrics may be found in the\n        apmReportTable.\n\n        The flows(1) aggregation is the simplest. All transactions\n        that share common application/server/client 3-tuples are\n        aggregated together, resulting in a set of metrics for all\n        such unique 3-tuples.\n\n        The clients(2) aggregation results in somewhat more\n        aggregation (i.e., fewer resulting records). All transactions\n        that share common application/client tuples are aggregated\n        together, resulting in a set of metrics for all such unique\n        tuples.\n\n        The servers(3) aggregation usually results in still more\n        aggregation (i.e., fewer resulting records). All transactions\n        that share common application/server tuples are aggregated\n        together, resulting in a set of metrics for all such unique\n        tuples.\n\n        The applications(4) aggregation results in the most\n        aggregation (i.e., the fewest resulting records). All\n\n        transactions that share a common application are aggregated\n        together, resulting in a set of metrics for all such unique\n        applications.\n\n        Note that it is not meaningful to aggregate applications, as\n        different applications have widely varying characteristics.\n        As a result, this set of aggregations is complete.\n\n        This object may not be modified if the associated\n        apmReportControlStatus object is equal to active(1).')
apmReportControlInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 4), Unsigned32().clone(3600)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlInterval.setDescription("The interval in seconds over which data is accumulated before\n        being aggregated into a report in the apmReportTable.  All\n        reports with the same apmReportControlIndex will be based on\n        the same interval. This object must be greater than zero.\n\n        Many users desire that these reports be synchronized to within\n        seconds of the beginning of the hour because the results may\n        be correlated more meaningfully to business behavior and so\n        that data from multiple agents is aggregated over the same\n        time periods. Thus management software may take extra effort\n        to synchronize reports to the beginning of the hour and to one\n        another. However, the agent must not allow reports to 'drift'\n        over time as they will quickly become unsynchronized. In\n        particular, if there is any fixed processing delay between\n        reports, the reports should deduct this time from the interval\n        so that reports don't drift.\n\n        This object may not be modified if the associated\n        apmReportControlStatus object is equal to active(1).")
apmReportControlRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 5), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlRequestedSize.setDescription('The number of entries requested to be allocated for each\n        report generated on behalf of this entry.')
apmReportControlGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlGrantedSize.setDescription("The number of entries per report the agent has allocated\n        based on the requested amount in apmReportControlRequestedSize.\n        Since multiple reports are saved, the total number of entries\n        allocated will be this number multiplied by the value of\n        apmReportControlGrantedReports, or 1 if that object doesn't\n        exist.\n\n        When the associated apmReportControlRequestedSize object is\n        created or modified, the agent should set this object as\n        closely to the requested value as is possible for the\n        particular implementation and available resources. When\n        considering resources available, the agent must consider its\n        ability to allocate this many entries for all reports.\n\n        Note that while the actual number of entries stored in the\n        reports may fluctuate due to changing conditions, the agent\n        must continue to have storage available to satisfy the full\n        report size for all reports when necessary. Further, the agent\n        must not lower this value except as a result of a set to the\n        associated apmReportControlRequestedSize object.")
apmReportControlRequestedReports = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlRequestedReports.setDescription('The number of saved reports requested to be allocated on\n        behalf of this entry.')
apmReportControlGrantedReports = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlGrantedReports.setDescription("The number of saved reports the agent has allocated\n        based on the requested amount in\n        apmReportControlRequestedReports. Since each report can have\n        many entries, the total number of entries allocated will be\n        this number multiplied by the value of\n        apmReportControlGrantedSize, or 1 if that object doesn't\n        exist.\n\n        When the associated apmReportControlRequestedReports object is\n        created or modified, the agent should set this object as\n        closely to the requested value as is possible for the\n        particular implementation and available resources. When\n        considering resources available, the agent must consider its\n        ability to allocate this many reports each with the number of\n        entries represented by apmReportControlGrantedSize, or 1 if\n        that object doesn't exist.\n\n        Note that while the storage required for each report may\n        fluctuate due to changing conditions, the agent must continue\n        to have storage available to satisfy the full report size for\n        all reports when necessary. Further, the agent must not lower\n        this value except as a result of a set to the associated\n        apmReportControlRequestedSize object.")
apmReportControlStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlStartTime.setDescription('The value of sysUpTime when the system began processing the\n        report in progress. Note that the report in progress is not\n        available.\n\n        This object may be used by the management station to figure\n        out the start time for all previous reports saved for this\n        apmReportControlEntry, as reports are started at fixed\n        intervals.')
apmReportControlReportNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlReportNumber.setDescription('The number of the report in progress. When an\n        apmReportControlEntry is activated, the first report will be\n        numbered one.')
apmReportControlDeniedInserts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlDeniedInserts.setDescription("The number of failed attempts to add an entry to reports for\n\n        this apmReportControlEntry because the number of entries\n        would have exceeded apmReportControlGrantedSize.\n\n        This number is valuable in determining if enough entries have\n        been allocated for reports in light of fluctuating network\n        usage. Note that since an entry that is denied will often be\n        attempted again, this number will not predict the exact number\n        of additional entries needed, but can be used to understand\n        the relative magnitude of the problem.\n\n        Also note that there is no ordering specified for the entries\n        in the report, thus there are no rules for which entries will\n        be omitted when not enough entries are available. As a\n        consequence, the agent is not required to delete 'least\n        valuable' entries first.")
apmReportControlDroppedFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlDroppedFrames.setDescription('The total number of frames which were received by the agent\n        and therefore not accounted for in the *StatsDropEvents, but\n        for which the agent chose not to count for this entry for\n        whatever reason.  Most often, this event occurs when the agent\n        is out of some resources and decides to shed load from this\n        collection.\n\n        This count does not include packets that were not counted\n        because they had MAC-layer errors.\n\n        This counter is only relevant if this apm report is based on\n        a data source whose collection methodology is based on\n        analyzing network traffic.\n\n        Note that if the apmReportTables are inactive because no\n        applications are enabled in the application directory, this\n        value should be 0.\n\n        Note that, unlike the dropEvents counter, this number is the\n        exact number of frames dropped.')
apmReportControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 13), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlOwner.setDescription('The entity that configured this entry and is\n        therefore using the resources assigned to it.')
apmReportControlStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 14), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlStorageType.setDescription("The storage type of this apmReportControlEntry. If the value\n        of this object is 'permanent', no objects in this row need to\n        be writable.")
apmReportControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlStatus.setDescription('The status of this apmReportControlEntry.\n\n        An entry may not exist in the active state unless all\n        objects in the entry have an appropriate value. The only\n        objects in the entry that may be modified while the entry is\n        in the active state are apmReportControlRequestedSize and\n        apmReportControlRequestedReports.\n\n        If this object is not equal to active(1), all\n        associated entries in the apmReportTable shall be deleted\n        by the agent.')
apmReportTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 10), )
if mibBuilder.loadTexts: apmReportTable.setDescription('The data resulting from aggregated APM reports. Consult the\n        definition of apmReportControlAggregationType for the\n        definition of the various types of aggregations.')
apmReportEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1), ).setIndexNames((0, "APM-MIB", "apmReportControlIndex"), (0, "APM-MIB", "apmReportIndex"), (0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"), (0, "RMON2-MIB", "protocolDirLocalIndex"), (0, "APM-MIB", "apmReportServerAddress"), (0, "APM-MIB", "apmNameClientID"))
if mibBuilder.loadTexts: apmReportEntry.setDescription("A conceptual row in the apmReportTable.\n        The apmReportControlIndex value in the index identifies the\n        apmReportControlEntry on whose behalf this entry was created.\n        The apmReportIndex value in the index identifies which report\n        (in the series of reports) this entry is a part of.\n        The apmAppDirAppLocalIndex value in the index identifies\n        the common application of the transactions aggregated in this\n        entry.\n        The apmAppDirResponsivenessType value in the index\n        identifies the type of responsiveness metric reported by\n        this entry and uniquely identifies this entry when more\n        than one responsiveness metric is measured for a flow.\n        Entries will only exist in this table for those\n        combinations of AppLocalIndex and ResponsivenessType\n        that are configured 'on(1)'.\n        The protocolDirLocalIndex value in the index identifies\n        the network layer protocol of the apmReportServerAddress.\n        When the associated apmReportControlAggregationType value is\n        equal to applications(4) or clients(2), this\n        protocolDirLocalIndex value will equal 0.\n        The apmReportServerAddress value in the index identifies the\n        network layer address of the server in transactions aggregated\n        in this entry.\n        The apmNameClientID value in the index identifies the\n        client in transactions aggregated in this entry. If the\n        associated apmReportControlAggregationType is equal to\n        applications(4) or servers(3), then this protocolDirLocalIndex\n        value will equal 0.\n\n        An example of the indexing of this entry is\n        apmReportTransactionCount.3.15.3.1.8.4.192.168.1.2.3232235788\n\n        Note that some combinations of index values may result in an\n        index that exceeds 128 sub-identifiers in length which exceeds\n        the maximum for the SNMP protocol. Implementations should take\n        care to avoid such combinations.")
apmReportIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: apmReportIndex.setDescription('The value of apmReportControlReportNumber for the report to\n        which this entry belongs.')
apmReportServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 2), ProtocolDirNetworkAddress())
if mibBuilder.loadTexts: apmReportServerAddress.setDescription("The network server address for this apmReportEntry.\n\n        This is represented as an octet string with\n        specific semantics and length as identified\n        by the protocolDirLocalIndex component of the index.\n\n        Since this object is an index variable, it is encoded in the\n        index according to the index encoding rules.  For example, if\n        the protocolDirLocalIndex indicates an encapsulation of ip,\n        this object is encoded as a length octet of 4, followed by the\n        4 octets of the ip address, in network byte order. Care\n        should be taken to avoid values of this object that, in\n        conjunction with the other index variables, would result in an\n        index longer than SNMP's maximum of 128 subidentifiers.\n\n        If the associated apmReportControlAggregationType is equal to\n        applications(4) or clients(2), then this object will be a null\n        string and will be encoded simply as a length octet of 0.")
apmReportTransactionCount = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportTransactionCount.setDescription('The total number of transactions aggregated into this record.')
apmReportSuccessfulTransactions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportSuccessfulTransactions.setDescription('The total number of successful transactions aggregated into\n        this record.')
apmReportResponsivenessMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessMean.setDescription('The arithmetic mean of the responsiveness metrics for all\n        successful transactions aggregated into this record.')
apmReportResponsivenessMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessMin.setDescription('The minimum of the responsiveness metrics for all\n        successful transactions aggregated into this record.')
apmReportResponsivenessMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessMax.setDescription('The maximum of the responsiveness metrics for all\n        successful transactions aggregated into this record.')
apmReportResponsivenessB1 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB1.setDescription('The number of successful transactions aggregated into this\n        record whose responsiveness was less than boundary1 value for\n        this application.')
apmReportResponsivenessB2 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB2.setDescription('The number of successful transactions aggregated into this\n        record whose responsiveness did not fall into Bucket 1 and was\n        greater than or equal to the boundary1 value for this\n        application and less than the boundary2 value for this\n        application.')
apmReportResponsivenessB3 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB3.setDescription('The number of successful transactions aggregated into this\n        record whose responsiveness did not fall into Bucket 1 or 2\n        and as greater than or equal to the boundary2 value for this\n        application and less than the boundary3 value for this\n        application.')
apmReportResponsivenessB4 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB4.setDescription('The number of successful transactions aggregated into this\n        record whose responsiveness did not fall into Buckets 1\n        through 3 and was greater than or equal to the boundary3 value\n        for this application and less than the boundary4 value for\n        this application.')
apmReportResponsivenessB5 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB5.setDescription('The number of successful transactions aggregated into this\n        record whose responsiveness did not fall into Buckets 1\n        through 4 and was greater than or equal to the boundary4 value\n        for this application and less than the boundary5 value for\n        this application.')
apmReportResponsivenessB6 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB6.setDescription('The number of successful transactions aggregated into this\n        record whose responsiveness did not fall into Buckets 1\n        through 5 and was greater than or equal to the\n        boundary5 value for this application and less than the\n        boundary6 value for this application.')
apmReportResponsivenessB7 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 14), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB7.setDescription('The number of successful transactions aggregated into this\n        record whose responsiveness did not fall into Buckets 1\n        through 6 and was greater than or equal to the boundary6 value\n        for this application.')
apmTransactionTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 11), )
if mibBuilder.loadTexts: apmTransactionTable.setDescription('This table contains transactions that are currently running\n        or have recently finished.')
apmTransactionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1), ).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"), (0, "RMON2-MIB", "protocolDirLocalIndex"), (0, "APM-MIB", "apmTransactionServerAddress"), (0, "APM-MIB", "apmNameClientID"), (0, "APM-MIB", "apmTransactionID"))
if mibBuilder.loadTexts: apmTransactionEntry.setDescription("A conceptual row in the apmTransactionTable.\n\n        The apmAppDirAppLocalIndex value in the index identifies\n        the application of the transaction represented by this entry.\n        The apmAppDirResponsivenessType value in the index\n        identifies the type of responsiveness metric reported by\n        this entry and uniquely identifies this entry when more\n        than one responsiveness metric is measured for a flow.\n        Entries will only exist in this table for those\n        combinations of AppLocalIndex and ResponsivenessType\n        that are configured 'on(1)'.\n        The protocolDirLocalIndex value in the index identifies\n        the network layer protocol of the apmTransactionServerAddress.\n        The apmTransactionServerAddress value in the index identifies\n        the network layer address of the server in the transaction\n        represented by this entry.\n        The apmNameClientID value in the index identifies the\n        client in the transaction represented by this entry.\n\n        An example of the indexing of this entry is\n        apmTransactionCount.3.1.8.4.192.168.1.2.3232235788.2987\n\n        Note that some combinations of index values may result in an\n        index that exceeds 128 sub-identifiers in length which exceeds\n        the maximum for the SNMP protocol. Implementations should take\n        care to avoid such combinations.")
apmTransactionServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 1), ProtocolDirNetworkAddress().subtype(subtypeSpec=ValueSizeConstraint(1,255)))
if mibBuilder.loadTexts: apmTransactionServerAddress.setDescription("The network server address for this apmTransactionEntry.\n\n        This is represented as an octet string with specific semantics\n        and length as identified by the protocolDirLocalIndex\n        component of the index. This object may not be the zero length\n        string.\n\n        For example, if the protocolDirLocalIndex indicates an\n        encapsulation of ip, this object is encoded as a length octet\n        of 4, followed by the 4 octets of the ip address, in network\n        byte order. Care should be taken to avoid values of this\n        object that, in conjunction with the other index variables,\n        would result in an index longer than SNMP's maximum of 128\n        subidentifiers.")
apmTransactionID = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: apmTransactionID.setDescription("A unique value for this transaction amongst other\n        transactions sharing the same application layer protocol and\n        server and client addresses. Implementations may choose to use\n        the value of the client's source port, when possible.")
apmTransactionResponsiveness = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmTransactionResponsiveness.setDescription('The current value of the responsiveness metric for this\n        transaction. If this transaction has completed, the final\n        value of the metric will be available.\n\n        Note that this value may change over the lifetime of the\n        transaction and it is the final value of this metric that is\n        recorded as the responsiveness of the transaction for use in\n        other APM MIB functions.')
apmTransactionAge = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 4), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmTransactionAge.setDescription('If this transaction is still executing, this value shall be\n\n        the length of time since it was started. If it has completed,\n        this value shall be the length of time it was executing.')
apmTransactionSuccess = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 5), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmTransactionSuccess.setDescription('The success of this transaction up to this time. Once a\n        transaction has been marked as failed, it cannot move back\n        into the successful state.')
apmTransactionsRequestedHistorySize = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 12), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmTransactionsRequestedHistorySize.setDescription("The maximum number of completed transactions desired to be\n        retained in the apmTransactionTable. If the agent doesn't have\n        enough resources to retain this many, it will retain as many as\n        possible. Regardless of this value, the agent must attempt to\n        keep records for all current transactions it is monitoring.\n\n        The value of this object must persist across reboots.")
apmExceptionTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 13), )
if mibBuilder.loadTexts: apmExceptionTable.setDescription('This table creates filters so that a management station can\n        get immediate notification of a transaction that has had poor\n\n        availability or responsiveness.\n\n        Each apmExceptionEntry is associated with a particular type of\n        transaction and is applied to all transactions of that\n        type. Multiple apmExceptionEntries may be associated with a\n        particular type of transaction. A transaction type is\n        identified by the value of the apmAppDirAppLocalIndex\n        component of the index.\n\n        Because the quality of a transaction is not known until it is\n        completed, these thresholds are only applied after the\n        transaction has completed.')
apmExceptionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1), ).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"), (0, "APM-MIB", "apmExceptionIndex"))
if mibBuilder.loadTexts: apmExceptionEntry.setDescription('A conceptual row in the apmExceptionTable.\n\n        The apmAppDirAppLocalIndex value in the index identifies\n        the application this entry will monitor.\n        The apmAppDirResponsivenessType value in the index\n        identifies the type of responsiveness metric this entry will\n        monitor.')
apmExceptionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: apmExceptionIndex.setDescription('An index that uniquely identifies an entry in the\n        apmExceptionTable amongst other entries with equivalent index\n        values for apmAppDirAppLocalIndex and\n        apmAppDirResponsivenessType. Each such entry sets up\n        thresholds for a particular measurement of a particular\n        application.')
apmExceptionResponsivenessComparison = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("none", 1), ("greater", 2), ("less", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionResponsivenessComparison.setDescription('If this value is greater(2) or less(3), the associated\n        apmExceptionResponsivenessThreshold will be compared to this\n        value and an exception will be created if the responsiveness\n        is greater than the threshold (greater(2)) or less than the\n        threshold (less(3)).')
apmExceptionResponsivenessThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 3), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionResponsivenessThreshold.setDescription('The threshold that responsiveness metrics are compared to.')
apmExceptionUnsuccessfulException = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("off", 1), ("on", 2),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionUnsuccessfulException.setDescription('If this value is on(2), an exception will be created if a\n        transaction of the associated type is unsuccessful.')
apmExceptionResponsivenessEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmExceptionResponsivenessEvents.setDescription('The total number of responsiveness exceptions generated. This\n        counter will be incremented even if no notification was sent\n        due to notifications not being configured or due to exceeding\n        the apmNotificationMaxRate value.')
apmExceptionUnsuccessfulEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmExceptionUnsuccessfulEvents.setDescription('The total number of unsuccessful exceptions generated. This\n        counter will be incremented even if no notification was sent\n        due to notifications not being configured or due to exceeding\n        the apmNotificationMaxRate value.')
apmExceptionOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 7), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionOwner.setDescription('The entity that configured this entry and is\n        therefore using the resources assigned to it.')
apmExceptionStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 8), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionStorageType.setDescription("The storage type of this apmReportControlEntry. If the value\n        of this object is 'permanent', no objects in this row need to\n        be writable.")
apmExceptionStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionStatus.setDescription('The status of this apmExceptionEntry. The only objects in the\n        entry that may be modified while the entry is in the active\n        state are apmExceptionResponsivenessComparison,\n        apmExceptionResponsivenessThreshold and\n        apmExceptionUnsuccessfulException.')
apmThroughputExceptionMinTime = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 14), Unsigned32().clone(10)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmThroughputExceptionMinTime.setDescription("Because the responsiveness for throughput-oriented\n        transactions is divided by the elapsed time, it can be very\n        sensitive to short-term performance variations for\n        transactions that take a short period of time. For example,\n        when downloading a very short file, a single dropped packet\n        could double or triple the total response time.\n\n        Further, throughput is usually examined for applications that\n        transfer a lot of data, and when doing so it is helpful to\n        conceptualize transaction costs that are proportional to the\n        amount of data separately from those costs that are relatively\n        fixed (i.e., independent of the amount of data).  For very\n        short transactions, these fixed transaction costs (handshake,\n        setup time, authentication, round-trip time) may dominate the\n        total response time for the transaction, resulting in\n        throughput measurements that aren't really proportional to the\n        network's, server's and client's combined data throughput\n        capability.\n\n        This object controls the minimum number of seconds that an\n        throughput-based transaction must exceed before an exception\n        can be generated for it. If this object is set to zero, then\n        all throughput-based transactions are candidates for\n        exceptions.\n\n        The value of this object must persist across reboots.")
apmNotificationMaxRate = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 15), Unsigned32().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmNotificationMaxRate.setDescription('The maximum number of notifications that can be generated\n        from this agent by the apmExceptionTable in any 60 second\n        period.\n\n        The value of this object must persist across reboots.')
apmNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 0))
apmTransactionResponsivenessAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 23, 0, 1)).setObjects(*(("APM-MIB", "apmExceptionResponsivenessThreshold"), ("APM-MIB", "apmTransactionResponsiveness"),))
if mibBuilder.loadTexts: apmTransactionResponsivenessAlarm.setDescription('Notification sent when a transaction exceeds a threshold\n        defined in the apmException table. The index of the\n        included apmExceptionResponsivenessThreshold object identifies\n        the apmExceptionEntry that specified the threshold. The\n        apmTransactionResponsiveness variable identifies the actual\n        transaction and its responsiveness.\n\n        Agent implementors are urged to include additional data\n        objects in the alarm that may explain the reason for the\n        alarm. It is helpful to include such data in the alarm because\n        it describes the situation at the time the alarm was\n        generated, where polls after the fact may not provide\n        meaningful information. Examples of such information are CPU\n        load, memory utilization, network utilization, and transaction\n        statistics.')
apmTransactionUnsuccessfulAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 23, 0, 2)).setObjects(*(("APM-MIB", "apmExceptionResponsivenessThreshold"),))
if mibBuilder.loadTexts: apmTransactionUnsuccessfulAlarm.setDescription('Notification sent when a transaction is unsuccessful.\n        The index of the included apmExceptionResponsivenessThreshold\n        object identifies both the type of the transaction that caused\n        this notification as well as the apmExceptionEntry that\n        specified the threshold.\n\n        Agent implementors are urged to include additional data\n        objects in the alarm that may explain the reason for the\n        alarm. It is helpful to include such data in the alarm because\n        it describes the situation at the time the alarm was\n        generated, where polls after the fact may not provide\n        meaningful information. Examples of such information are CPU\n        load, memory utilization, network utilization, and transaction\n        statistics.')
apmCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 23, 2, 1, 1)).setObjects(*(("APM-MIB", "apmAppDirGroup"), ("APM-MIB", "apmReportGroup"), ("APM-MIB", "apmUserDefinedApplicationsGroup"), ("APM-MIB", "apmTransactionGroup"), ("APM-MIB", "apmExceptionGroup"), ("APM-MIB", "apmNotificationGroup"),))
if mibBuilder.loadTexts: apmCompliance.setDescription('Describes the requirements for conformance to\n        the APM MIB')
apmAppDirGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 1)).setObjects(*(("APM-MIB", "apmAppDirConfig"), ("APM-MIB", "apmAppDirResponsivenessBoundary1"), ("APM-MIB", "apmAppDirResponsivenessBoundary2"), ("APM-MIB", "apmAppDirResponsivenessBoundary3"), ("APM-MIB", "apmAppDirResponsivenessBoundary4"), ("APM-MIB", "apmAppDirResponsivenessBoundary5"), ("APM-MIB", "apmAppDirResponsivenessBoundary6"), ("APM-MIB", "apmBucketBoundaryLastChange"), ("APM-MIB", "apmAppDirID"), ("APM-MIB", "apmNameMachineName"), ("APM-MIB", "apmNameUserName"),))
if mibBuilder.loadTexts: apmAppDirGroup.setDescription('The APM MIB directory of applications and application verbs.')
apmUserDefinedApplicationsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 2)).setObjects(*(("APM-MIB", "apmHttpFilterAppLocalIndex"), ("APM-MIB", "apmHttpFilterServerProtocol"), ("APM-MIB", "apmHttpFilterServerAddress"), ("APM-MIB", "apmHttpFilterURLPath"), ("APM-MIB", "apmHttpFilterMatchType"), ("APM-MIB", "apmHttpFilterOwner"), ("APM-MIB", "apmHttpFilterStorageType"), ("APM-MIB", "apmHttpFilterRowStatus"), ("APM-MIB", "apmHttpIgnoreUnregisteredURLs"), ("APM-MIB", "apmHttp4xxIsFailure"), ("APM-MIB", "apmUserDefinedAppParentIndex"), ("APM-MIB", "apmUserDefinedAppApplication"),))
if mibBuilder.loadTexts: apmUserDefinedApplicationsGroup.setDescription('Objects used for creating and managing user-defined\n        applications.')
apmReportGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 3)).setObjects(*(("APM-MIB", "apmReportControlDataSource"), ("APM-MIB", "apmReportControlAggregationType"), ("APM-MIB", "apmReportControlInterval"), ("APM-MIB", "apmReportControlRequestedSize"), ("APM-MIB", "apmReportControlGrantedSize"), ("APM-MIB", "apmReportControlRequestedReports"), ("APM-MIB", "apmReportControlGrantedReports"), ("APM-MIB", "apmReportControlStartTime"), ("APM-MIB", "apmReportControlReportNumber"), ("APM-MIB", "apmReportControlDeniedInserts"), ("APM-MIB", "apmReportControlDroppedFrames"), ("APM-MIB", "apmReportControlOwner"), ("APM-MIB", "apmReportControlStorageType"), ("APM-MIB", "apmReportControlStatus"), ("APM-MIB", "apmReportTransactionCount"), ("APM-MIB", "apmReportSuccessfulTransactions"), ("APM-MIB", "apmReportResponsivenessMean"), ("APM-MIB", "apmReportResponsivenessMin"), ("APM-MIB", "apmReportResponsivenessMax"), ("APM-MIB", "apmReportResponsivenessB1"), ("APM-MIB", "apmReportResponsivenessB2"), ("APM-MIB", "apmReportResponsivenessB3"), ("APM-MIB", "apmReportResponsivenessB4"), ("APM-MIB", "apmReportResponsivenessB5"), ("APM-MIB", "apmReportResponsivenessB6"), ("APM-MIB", "apmReportResponsivenessB7"),))
if mibBuilder.loadTexts: apmReportGroup.setDescription('The apm report group controls the creation and retrieval of\n        reports that aggregate application performance.')
apmTransactionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 4)).setObjects(*(("APM-MIB", "apmTransactionResponsiveness"), ("APM-MIB", "apmTransactionAge"), ("APM-MIB", "apmTransactionSuccess"), ("APM-MIB", "apmTransactionsRequestedHistorySize"),))
if mibBuilder.loadTexts: apmTransactionGroup.setDescription('The apm transaction group contains statistics for\n        individual transactions.')
apmExceptionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 5)).setObjects(*(("APM-MIB", "apmExceptionResponsivenessComparison"), ("APM-MIB", "apmExceptionResponsivenessThreshold"), ("APM-MIB", "apmExceptionUnsuccessfulException"), ("APM-MIB", "apmExceptionResponsivenessEvents"), ("APM-MIB", "apmExceptionUnsuccessfulEvents"), ("APM-MIB", "apmExceptionOwner"), ("APM-MIB", "apmExceptionStorageType"), ("APM-MIB", "apmExceptionStatus"), ("APM-MIB", "apmThroughputExceptionMinTime"), ("APM-MIB", "apmNotificationMaxRate"),))
if mibBuilder.loadTexts: apmExceptionGroup.setDescription('The apm exception group causes notifications to be sent\n        whenever transactions are detected that had poor availability\n        or responsiveness.')
apmNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 6)).setObjects(*(("APM-MIB", "apmTransactionResponsivenessAlarm"), ("APM-MIB", "apmTransactionUnsuccessfulAlarm"),))
if mibBuilder.loadTexts: apmNotificationGroup.setDescription('Notifications sent by an APM MIB agent.')
mibBuilder.exportSymbols("APM-MIB", apmHttpFilterRowStatus=apmHttpFilterRowStatus, apmHttpIgnoreUnregisteredURLs=apmHttpIgnoreUnregisteredURLs, apmReportResponsivenessMin=apmReportResponsivenessMin, apmNameTable=apmNameTable, apmReportControlTable=apmReportControlTable, apmTransactionTable=apmTransactionTable, apmReportControlInterval=apmReportControlInterval, apmUserDefinedAppApplication=apmUserDefinedAppApplication, apmExceptionIndex=apmExceptionIndex, apmUserDefinedAppParentIndex=apmUserDefinedAppParentIndex, apmAppDirAppLocalIndex=apmAppDirAppLocalIndex, apmHttpFilterOwner=apmHttpFilterOwner, apmReportControlOwner=apmReportControlOwner, apmUserDefinedAppEntry=apmUserDefinedAppEntry, apmReportSuccessfulTransactions=apmReportSuccessfulTransactions, apmReportControlReportNumber=apmReportControlReportNumber, apmNameMachineName=apmNameMachineName, apmHttpFilterStorageType=apmHttpFilterStorageType, apmExceptionStatus=apmExceptionStatus, apmTransactionsRequestedHistorySize=apmTransactionsRequestedHistorySize, apmReportResponsivenessB5=apmReportResponsivenessB5, apmReportResponsivenessMax=apmReportResponsivenessMax, apmReportControlRequestedSize=apmReportControlRequestedSize, apmNameClientAddress=apmNameClientAddress, apmReportServerAddress=apmReportServerAddress, apmReportTransactionCount=apmReportTransactionCount, apmReportEntry=apmReportEntry, apmReportIndex=apmReportIndex, ProtocolDirNetworkAddress=ProtocolDirNetworkAddress, apmHttpFilterMatchType=apmHttpFilterMatchType, apmReportResponsivenessB4=apmReportResponsivenessB4, apmTransactionResponsiveness=apmTransactionResponsiveness, apmAppDirEntry=apmAppDirEntry, apmHttpFilterEntry=apmHttpFilterEntry, apm=apm, apmNameEntry=apmNameEntry, apmReportResponsivenessMean=apmReportResponsivenessMean, apmAppDirID=apmAppDirID, apmAppDirResponsivenessBoundary4=apmAppDirResponsivenessBoundary4, apmReportGroup=apmReportGroup, apmExceptionStorageType=apmExceptionStorageType, DataSourceOrZero=DataSourceOrZero, apmCompliance=apmCompliance, apmAppDirGroup=apmAppDirGroup, apmUserDefinedApplicationsGroup=apmUserDefinedApplicationsGroup, apmAppDirResponsivenessBoundary1=apmAppDirResponsivenessBoundary1, apmUserDefinedAppTable=apmUserDefinedAppTable, apmTransactionAge=apmTransactionAge, apmNotifications=apmNotifications, apmAppDirResponsivenessType=apmAppDirResponsivenessType, apmAppDirResponsivenessBoundary5=apmAppDirResponsivenessBoundary5, apmReportControlRequestedReports=apmReportControlRequestedReports, apmReportResponsivenessB6=apmReportResponsivenessB6, apmHttpFilterAppLocalIndex=apmHttpFilterAppLocalIndex, apmReportControlGrantedSize=apmReportControlGrantedSize, apmReportControlAggregationType=apmReportControlAggregationType, apmNotificationMaxRate=apmNotificationMaxRate, apmTransactionGroup=apmTransactionGroup, apmReportResponsivenessB3=apmReportResponsivenessB3, apmExceptionEntry=apmExceptionEntry, apmAppDirConfig=apmAppDirConfig, apmReportControlStatus=apmReportControlStatus, apmNameMappingStartTime=apmNameMappingStartTime, apmReportResponsivenessB2=apmReportResponsivenessB2, apmReportControlIndex=apmReportControlIndex, apmExceptionUnsuccessfulEvents=apmExceptionUnsuccessfulEvents, apmNameClientID=apmNameClientID, apmAppDirTable=apmAppDirTable, apmReportControlGrantedReports=apmReportControlGrantedReports, apmTransactionID=apmTransactionID, apmReportControlDroppedFrames=apmReportControlDroppedFrames, apmReportResponsivenessB1=apmReportResponsivenessB1, PYSNMP_MODULE_ID=apm, apmHttp4xxIsFailure=apmHttp4xxIsFailure, apmHttpFilterServerAddress=apmHttpFilterServerAddress, apmExceptionOwner=apmExceptionOwner, apmAppDirResponsivenessBoundary6=apmAppDirResponsivenessBoundary6, apmThroughputExceptionMinTime=apmThroughputExceptionMinTime, apmExceptionGroup=apmExceptionGroup, apmHttpFilterURLPath=apmHttpFilterURLPath, apmHttpFilterServerProtocol=apmHttpFilterServerProtocol, apmReportControlEntry=apmReportControlEntry, apmCompliances=apmCompliances, apmReportTable=apmReportTable, apmReportControlDeniedInserts=apmReportControlDeniedInserts, RmonClientID=RmonClientID, apmTransactionUnsuccessfulAlarm=apmTransactionUnsuccessfulAlarm, apmReportResponsivenessB7=apmReportResponsivenessB7, apmTransactionEntry=apmTransactionEntry, TransactionAggregationType=TransactionAggregationType, apmTransactionServerAddress=apmTransactionServerAddress, apmExceptionResponsivenessEvents=apmExceptionResponsivenessEvents, apmConformance=apmConformance, apmReportControlStorageType=apmReportControlStorageType, apmReportControlStartTime=apmReportControlStartTime, apmNameUserName=apmNameUserName, apmTransactionSuccess=apmTransactionSuccess, apmHttpFilterTable=apmHttpFilterTable, apmTransactionResponsivenessAlarm=apmTransactionResponsivenessAlarm, apmMibObjects=apmMibObjects, apmGroups=apmGroups, apmExceptionTable=apmExceptionTable, apmExceptionUnsuccessfulException=apmExceptionUnsuccessfulException, apmNotificationGroup=apmNotificationGroup, apmAppDirResponsivenessBoundary2=apmAppDirResponsivenessBoundary2, apmReportControlDataSource=apmReportControlDataSource, apmBucketBoundaryLastChange=apmBucketBoundaryLastChange, apmExceptionResponsivenessComparison=apmExceptionResponsivenessComparison, AppLocalIndex=AppLocalIndex, apmAppDirResponsivenessBoundary3=apmAppDirResponsivenessBoundary3, apmHttpFilterIndex=apmHttpFilterIndex, apmExceptionResponsivenessThreshold=apmExceptionResponsivenessThreshold)
