/* Generated By:JavaCC: Do not edit this line. PhylipParser.java */
package es.uvigo.ei.sing.alter.parser;

import es.uvigo.ei.sing.alter.types.Phylip;
import es.uvigo.ei.sing.alter.types.PhylipSequence;
import java.io.StringReader;
import java.util.Vector;
import java.util.StringTokenizer;

/**
* PHYLIP format parser.
* @author Daniel Gomez Blanco
* @version 1.2
*/
public class PhylipParser implements PhylipParserConstants {
    /**
    * Static method that parses an input string and returns a MSA in PHYLIP format.
    * @param in Input string.
    * @return MSA in PHYLIP format.
    */
    public static Phylip parseMSA (String in) throws ParseException
    {
        //Parse string and return MSA
        PhylipParser parser = new PhylipParser(new StringReader(in));
        return parser.Phylip();
    }

/**
* Grammar's root production. Structure:<br>
* &nbsp;&nbsp;1. Any combination of spaces, tabs and new lines
* until a number is found.<br>
* &nbsp;&nbsp;2. Taxa number (number of sequences) followed by one or more
* spaces or tabs and the sequences length. Any character can follow until
* the end of the line, these characters will be omitted.<br>
* &nbsp;&nbsp;3. Any combination of spaces, tabs and new lines
* until the first sequence identifier.<br>
* &nbsp;&nbsp;4. If the MSA is in sequential format sequences with the following structure follow:<br>
* &nbsp;&nbsp;&nbsp;&nbsp;4a. Sequence identifier.<br>
* &nbsp;&nbsp;&nbsp;&nbsp;4b. Sequence data.<br>
* &nbsp;&nbsp;5. If the MSA is in interleaved format lines with the following structure follow:<br>
* &nbsp;&nbsp;&nbsp;&nbsp;5a. Sequence identifier.<br>
* &nbsp;&nbsp;&nbsp;&nbsp;5b. Sequence data line.<br>
* @return MSA in PHYLIP format.
*/
  final public Phylip Phylip() throws ParseException {
    Vector<PhylipSequence> seqs = new Vector<PhylipSequence>();
    int taxa, length;
    String id1, id2, data1, data2;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    taxa = Number();
    label_2:
    while (true) {
      jj_consume_token(BLANK);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
    }
    length = Number();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EOL:
      jj_consume_token(EOL);
      break;
    case BLANK:
      label_3:
      while (true) {
        jj_consume_token(BLANK);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_3;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
        Line();
        jj_consume_token(EOL);
        break;
      case EOL:
        jj_consume_token(EOL);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    id1 = Id();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EOL:
      jj_consume_token(EOL);
      break;
    case BLANK:
      label_5:
      while (true) {
        jj_consume_token(BLANK);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_5;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    data1 = DataLine();
    jj_consume_token(EOL);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    id2 = Id();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EOL:
      jj_consume_token(EOL);
      break;
    case BLANK:
      label_7:
      while (true) {
        jj_consume_token(BLANK);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[13] = jj_gen;
          break label_7;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    data2 = DataLine();
    jj_consume_token(EOL);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        if(data1.length() > data2.length())
        {
            StringBuffer data = new StringBuffer();
            data.append(data1);
            data.append(id2);
            data.append(data2);
            seqs.add(new PhylipSequence(id1, data.toString()));

            int read = seqs.firstElement().getData().length();

            seqs.firstElement().concat(Data(length - read));
            //It's sequential
            PhylipSeq(length, seqs);
        }
        else
        {
            seqs.add(new PhylipSequence(id1,data1));
            seqs.add(new PhylipSequence(id2,data2));
            //It's interleaved
            PhylipIntIds(taxa - 2, seqs);
            PhylipIntSeqs(taxa, seqs);
        }
    jj_consume_token(0);
        {if (true) return new Phylip(taxa, length, seqs);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses the first sequences of an interleaved PHYLIP, adding a new sequence
* to the vector for every parsed line.
* @param taxa Number of sequences to be parsed.
* @param seqs Sequences vector.
*/
  final public void PhylipIntIds(int taxa, Vector<PhylipSequence> seqs) throws ParseException {
    if (taxa == 0)
        return;
    int cont = 0;
    String id, data;
    label_9:
    while (true) {
      id = Id();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        label_10:
        while (true) {
          jj_consume_token(BLANK);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[18] = jj_gen;
            break label_10;
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
          jj_consume_token(EOL);
          break;
        default:
          jj_la1[19] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      data = DataLine();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 0:
        jj_consume_token(0);
        break;
      case EOL:
        jj_consume_token(EOL);
        label_11:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
          case BLANK:
            ;
            break;
          default:
            jj_la1[21] = jj_gen;
            break label_11;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            jj_consume_token(EOL);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          default:
            jj_la1[22] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            seqs.add(new PhylipSequence(id, data));
            cont++;
            if (cont == taxa)
                {if (true) return;}
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_9;
      }
    }
  }

/**
* Parses de rest of the sequences of an interleaved PHYLIP, concating them to the
* already read ones.
* @param taxa Number of sequences to be parsed.
* @param seqs Sequences vector.
*/
  final public void PhylipIntSeqs(int taxa, Vector<PhylipSequence> seqs) throws ParseException {
    int cont = 0;
    String data;
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case 9:
      case 10:
      case 11:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_12;
      }
      data = DataLine();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 0:
        jj_consume_token(0);
        break;
      case EOL:
        jj_consume_token(EOL);
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
          case BLANK:
            ;
            break;
          default:
            jj_la1[26] = jj_gen;
            break label_13;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            jj_consume_token(EOL);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          default:
            jj_la1[27] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            seqs.elementAt(cont).concat(data);
            cont++;
            if (cont == taxa)
                cont = 0;
    }
  }

/**
* Parses the sequences of a sequential PHYLIP, adding a new sequence to the sequences vector
* for every parsed line.
* @param length Length of the sequences to be parsed.
* @seqs Sequences vector.
*/
  final public void PhylipSeq(int length, Vector<PhylipSequence> seqs) throws ParseException {
    String id, data;
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case EOL:
        jj_consume_token(EOL);
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_15;
      }
      id = Id();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case EOL:
        jj_consume_token(EOL);
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      data = Data(length);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
        case BLANK:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_16;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          jj_consume_token(BLANK);
          break;
        case EOL:
          jj_consume_token(EOL);
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
            seqs.add(new PhylipSequence(id,data));
    }
  }

/**
* Parses a number.
* @return Parsed number.
*/
  final public int Number() throws ParseException {
    String s = "";
    Token t;
    label_17:
    while (true) {
      t = jj_consume_token(NUMBER);
            s = s.concat(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        ;
        break;
      default:
        jj_la1[35] = jj_gen;
        break label_17;
      }
    }
        {if (true) return Integer.parseInt(s);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a sequence identifier.
* @return Sequence identifier.
*/
  final public String Id() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 7:
    case 8:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 7:
        jj_consume_token(7);
        break;
      case 8:
        jj_consume_token(8);
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          t = jj_consume_token(BLANK);
          break;
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 9:
          t = jj_consume_token(9);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        default:
          jj_la1[37] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                    s.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 9:
        case 10:
        case 11:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_18;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 7:
        jj_consume_token(7);
        break;
      case 8:
        jj_consume_token(8);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case UPPER_CASE:
    case LOWER_CASE:
    case NUMBER:
    case ANY:
    case 9:
    case 10:
    case 11:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 9:
        t = jj_consume_token(9);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 11:
        t = jj_consume_token(11);
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                s.append(t.image);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_19;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 9:
          t = jj_consume_token(9);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 7:
          t = jj_consume_token(7);
          break;
        case 8:
          t = jj_consume_token(8);
          break;
        default:
          jj_la1[42] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                    s.append(t.image);
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return s.toString().trim();}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a line made up of any character sequence.
* @return Parsed line.
*/
  final public String Line() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPPER_CASE:
      t = jj_consume_token(UPPER_CASE);
      break;
    case LOWER_CASE:
      t = jj_consume_token(LOWER_CASE);
      break;
    case NUMBER:
      t = jj_consume_token(NUMBER);
      break;
    case ANY:
      t = jj_consume_token(ANY);
      break;
    case 9:
      t = jj_consume_token(9);
      break;
    case 10:
      t = jj_consume_token(10);
      break;
    case 11:
      t = jj_consume_token(11);
      break;
    case 7:
      t = jj_consume_token(7);
      break;
    case 8:
      t = jj_consume_token(8);
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        s.append(t.image);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
        ;
        break;
      default:
        jj_la1[45] = jj_gen;
        break label_20;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        t = jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 9:
        t = jj_consume_token(9);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 11:
        t = jj_consume_token(11);
        break;
      case 7:
        t = jj_consume_token(7);
        break;
      case 8:
        t = jj_consume_token(8);
        break;
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            s.append(t.image);
    }
        {if (true) return s.toString().trim();}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a data line. A data line can be made up of characters from "A" to "Z"
* (lowercase and uppercase), "-", "." or "?". Spaces and tabs are omitted.
* @return String with the data line (always uppercase).
*/
  final public String DataLine() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPPER_CASE:
      t = jj_consume_token(UPPER_CASE);
      break;
    case LOWER_CASE:
      t = jj_consume_token(LOWER_CASE);
      break;
    case 9:
      t = jj_consume_token(9);
      break;
    case 10:
      t = jj_consume_token(10);
      break;
    case 11:
      t = jj_consume_token(11);
      break;
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            s.append(t.image);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case 9:
      case 10:
      case 11:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_21;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        t = jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
      case LOWER_CASE:
      case 9:
      case 10:
      case 11:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case 9:
          t = jj_consume_token(9);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        default:
          jj_la1[49] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return s.toString().toUpperCase();}
    throw new Error("Missing return statement in function");
  }

/**
* Parses the data of a sequence with the given length. These data can be made up
* of any characters from "A" to "Z" (lowercase and uppercase), "-", "." or "?".
* Spaces, tabs and new lines are omitted.
* @param length Length of the sequence to be parsed.
* @return String with the sequence data (uppercase always).
*/
  final public String Data(int length) throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    int chars = 0;
    if (length==0) return "";
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          t = jj_consume_token(BLANK);
          break;
        case EOL:
          t = jj_consume_token(EOL);
          break;
        default:
          jj_la1[51] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case UPPER_CASE:
      case LOWER_CASE:
      case 9:
      case 10:
      case 11:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case 9:
          t = jj_consume_token(9);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        default:
          jj_la1[52] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
                chars++;
                if(chars == length)
                    {if (true) return s.toString().toUpperCase();}
        break;
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case 9:
      case 10:
      case 11:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_22;
      }
    }
        {if (true) return s.toString().toUpperCase();}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public PhylipParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[55];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x6,0x6,0x4,0x4,0xffa,0x6,0x6,0x6,0x4,0x2,0x6,0x6,0x6,0x4,0x2,0x6,0x6,0x6,0x4,0x2,0x6,0x6,0x6,0x3,0xff8,0xe18,0x6,0x6,0x3,0x6,0x6,0xff8,0x6,0x6,0x6,0x20,0x180,0xe7c,0xe7c,0x180,0xe78,0xff8,0xff8,0xff8,0xff8,0xffc,0xffc,0xe18,0xe1c,0xe18,0xe1c,0x6,0xe18,0xe1e,0xe1e,};
   }

  /** Constructor with InputStream. */
  public PhylipParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PhylipParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PhylipParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public PhylipParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PhylipParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public PhylipParser(PhylipParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(PhylipParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[12];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 55; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 12; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
