# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class IntegrationAccountPartner(Resource):
    """The integration account partner.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    :param partner_type: Required. The partner type. Possible values include:
     'NotSpecified', 'B2B'
    :type partner_type: str or ~azure.mgmt.logic.models.PartnerType
    :ivar created_time: The created time.
    :vartype created_time: datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: datetime
    :param metadata: The metadata.
    :type metadata: object
    :param content: Required. The partner content.
    :type content: ~azure.mgmt.logic.models.PartnerContent
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'partner_type': {'required': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'partner_type': {'key': 'properties.partnerType', 'type': 'PartnerType'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'content': {'key': 'properties.content', 'type': 'PartnerContent'},
    }

    def __init__(self, *, partner_type, content, location: str=None, tags=None, metadata=None, **kwargs) -> None:
        super(IntegrationAccountPartner, self).__init__(location=location, tags=tags, **kwargs)
        self.partner_type = partner_type
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.content = content
