# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EdifactFramingSettings(Model):
    """The Edifact agreement framing settings.

    All required parameters must be populated in order to send to Azure.

    :param service_code_list_directory_version: The service code list
     directory version.
    :type service_code_list_directory_version: str
    :param character_encoding: The character encoding.
    :type character_encoding: str
    :param protocol_version: Required. The protocol version.
    :type protocol_version: int
    :param data_element_separator: Required. The data element separator.
    :type data_element_separator: int
    :param component_separator: Required. The component separator.
    :type component_separator: int
    :param segment_terminator: Required. The segment terminator.
    :type segment_terminator: int
    :param release_indicator: Required. The release indicator.
    :type release_indicator: int
    :param repetition_separator: Required. The repetition separator.
    :type repetition_separator: int
    :param character_set: Required. The EDIFACT frame setting characterSet.
     Possible values include: 'NotSpecified', 'UNOB', 'UNOA', 'UNOC', 'UNOD',
     'UNOE', 'UNOF', 'UNOG', 'UNOH', 'UNOI', 'UNOJ', 'UNOK', 'UNOX', 'UNOY',
     'KECA'
    :type character_set: str or ~azure.mgmt.logic.models.EdifactCharacterSet
    :param decimal_point_indicator: Required. The EDIFACT frame setting
     decimal indicator. Possible values include: 'NotSpecified', 'Comma',
     'Decimal'
    :type decimal_point_indicator: str or
     ~azure.mgmt.logic.models.EdifactDecimalIndicator
    :param segment_terminator_suffix: Required. The EDIFACT frame setting
     segment terminator suffix. Possible values include: 'NotSpecified',
     'None', 'CR', 'LF', 'CRLF'
    :type segment_terminator_suffix: str or
     ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    """

    _validation = {
        'protocol_version': {'required': True},
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'segment_terminator': {'required': True},
        'release_indicator': {'required': True},
        'repetition_separator': {'required': True},
        'character_set': {'required': True},
        'decimal_point_indicator': {'required': True},
        'segment_terminator_suffix': {'required': True},
    }

    _attribute_map = {
        'service_code_list_directory_version': {'key': 'serviceCodeListDirectoryVersion', 'type': 'str'},
        'character_encoding': {'key': 'characterEncoding', 'type': 'str'},
        'protocol_version': {'key': 'protocolVersion', 'type': 'int'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'release_indicator': {'key': 'releaseIndicator', 'type': 'int'},
        'repetition_separator': {'key': 'repetitionSeparator', 'type': 'int'},
        'character_set': {'key': 'characterSet', 'type': 'EdifactCharacterSet'},
        'decimal_point_indicator': {'key': 'decimalPointIndicator', 'type': 'EdifactDecimalIndicator'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'SegmentTerminatorSuffix'},
    }

    def __init__(self, **kwargs):
        super(EdifactFramingSettings, self).__init__(**kwargs)
        self.service_code_list_directory_version = kwargs.get('service_code_list_directory_version', None)
        self.character_encoding = kwargs.get('character_encoding', None)
        self.protocol_version = kwargs.get('protocol_version', None)
        self.data_element_separator = kwargs.get('data_element_separator', None)
        self.component_separator = kwargs.get('component_separator', None)
        self.segment_terminator = kwargs.get('segment_terminator', None)
        self.release_indicator = kwargs.get('release_indicator', None)
        self.repetition_separator = kwargs.get('repetition_separator', None)
        self.character_set = kwargs.get('character_set', None)
        self.decimal_point_indicator = kwargs.get('decimal_point_indicator', None)
        self.segment_terminator_suffix = kwargs.get('segment_terminator_suffix', None)
