# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FileServerReference(Model):
    """Provides required information, for the service to be able to mount Azure
    FileShare on the cluster nodes.

    All required parameters must be populated in order to send to Azure.

    :param file_server: Required. Reference to the file server resource.
    :type file_server: ~azure.mgmt.batchai.models.ResourceId
    :param source_directory: Specifies the source directory in File Server
     that needs to be mounted. If this property is not specified, the entire
     File Server will be mounted.
    :type source_directory: str
    :param relative_mount_path: Required. Specifies the relative path on the
     compute node where the File Server will be mounted. Note that all cluster
     level file servers will be mounted under $AZ_BATCHAI_MOUNT_ROOT location
     and job level file servers will be mouted under
     $AZ_BATCHAI_JOB_MOUNT_ROOT.
    :type relative_mount_path: str
    :param mount_options: Specifies the mount options for File Server.
    :type mount_options: str
    """

    _validation = {
        'file_server': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'file_server': {'key': 'fileServer', 'type': 'ResourceId'},
        'source_directory': {'key': 'sourceDirectory', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileServerReference, self).__init__(**kwargs)
        self.file_server = kwargs.get('file_server', None)
        self.source_directory = kwargs.get('source_directory', None)
        self.relative_mount_path = kwargs.get('relative_mount_path', None)
        self.mount_options = kwargs.get('mount_options', None)
