# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JSONEntity(Model):
    """Exported Model - Extracted Entity from utterance.

    All required parameters must be populated in order to send to Azure.

    :param start_pos: Required. The index within the utterance where the
     extracted entity starts.
    :type start_pos: int
    :param end_pos: Required. The index within the utterance where the
     extracted entity ends.
    :type end_pos: int
    :param entity: Required. The entity name.
    :type entity: str
    """

    _validation = {
        'start_pos': {'required': True},
        'end_pos': {'required': True},
        'entity': {'required': True},
    }

    _attribute_map = {
        'start_pos': {'key': 'startPos', 'type': 'int'},
        'end_pos': {'key': 'endPos', 'type': 'int'},
        'entity': {'key': 'entity', 'type': 'str'},
    }

    def __init__(self, *, start_pos: int, end_pos: int, entity: str, **kwargs) -> None:
        super(JSONEntity, self).__init__(**kwargs)
        self.start_pos = start_pos
        self.end_pos = end_pos
        self.entity = entity
