/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.CaliperRc;
import com.google.caliper.util.Util;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class CaliperRcManager {
    public static CaliperRc loadOrCreate(File rcFile) {
        ImmutableMap<String, String> overrides;
        ImmutableMap<String, String> defaults;
        try {
            defaults = Util.loadProperties(Util.resourceSupplier(CaliperRc.class, "global.caliperrc"));
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        if (rcFile.exists()) {
            try {
                ImmutableMap<String, String> overrides2 = Util.loadProperties((InputSupplier<? extends InputStream>)Files.newInputStreamSupplier((File)rcFile));
                return CaliperRc.create(overrides2, defaults);
            }
            catch (IOException keepGoing) {
                // empty catch block
            }
        }
        InputSupplier<InputStream> supplier = Util.resourceSupplier(CaliperRc.class, "default.caliperrc");
        CaliperRcManager.tryCopyIfNeeded(supplier, rcFile);
        try {
            overrides = Util.loadProperties(supplier);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return CaliperRc.create(overrides, defaults);
    }

    private static void tryCopyIfNeeded(InputSupplier<? extends InputStream> supplier, File rcFile) {
        if (!rcFile.exists()) {
            try {
                Files.copy(supplier, (File)rcFile);
            }
            catch (IOException e) {
                rcFile.delete();
            }
        }
    }
}

