/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.expr.GenericProc;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleMethod;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.functions.Format;
import gnu.kawa.functions.MultiplyOp;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.Location;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.WrongType;
import gnu.math.BitOps;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.Duration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RatNum;
import gnu.math.RealNum;
import gnu.math.Unit;
import kawa.lib.syntax;
import kawa.standard.require;

public class numbers
extends ModuleBody
implements Runnable {
    static final Location loc$$Lsnumber$Gr;
    static final Location loc$$Lsgnu$Dtexpr$DtGenericProc$Gr;
    static final Location loc$$Lsgnu$Dtmath$DtDFloNum$Gr;
    static final Location loc$$Lsstring$Gr;
    static final Location loc$$Lsjava$Dtlang$DtIllegalArgumentException$Gr;
    public static final ModuleMethod number$Qu;
    public static final ModuleMethod quantity$Qu;
    public static final ModuleMethod complex$Qu;
    public static final ModuleMethod real$Qu;
    public static final ModuleMethod rational$Qu;
    public static final ModuleMethod integer$Qu;
    public static final ModuleMethod exact$Qu;
    public static final ModuleMethod inexact$Qu;
    public static final ModuleMethod zero$Qu;
    public static final ModuleMethod positive$Qu;
    public static final ModuleMethod negative$Qu;
    public static final ModuleMethod odd$Qu;
    public static final ModuleMethod even$Qu;
    public static final ModuleMethod max;
    public static final ModuleMethod min;
    public static final ModuleMethod abs;
    public static final ModuleMethod quotient;
    public static final ModuleMethod remainder;
    public static final ModuleMethod modulo;
    public static final ModuleMethod gcd;
    public static final ModuleMethod lcm;
    public static final ModuleMethod numerator;
    public static final ModuleMethod denominator;
    public static final ModuleMethod floor;
    public static final ModuleMethod ceiling;
    public static final ModuleMethod truncate;
    public static final ModuleMethod round;
    public static final ModuleMethod rationalize;
    public static final ModuleMethod exp;
    public static final ModuleMethod log;
    public static final ModuleMethod sin;
    public static final ModuleMethod cos;
    public static final ModuleMethod tan;
    public static final ModuleMethod asin;
    public static final ModuleMethod acos;
    public static final GenericProc atan;
    public static final ModuleMethod sqrt;
    public static final ModuleMethod make$Mnrectangular;
    public static final ModuleMethod make$Mnpolar;
    public static final ModuleMethod real$Mnpart;
    public static final ModuleMethod imag$Mnpart;
    public static final ModuleMethod magnitude;
    public static final ModuleMethod angle;
    public static final ModuleMethod exact$Mn$Grinexact;
    public static final ModuleMethod inexact$Mn$Grexact;
    public static final ModuleMethod arithmetic$Mnshift;
    public static final ModuleMethod lognot;
    public static final ModuleMethod logop;
    public static final ModuleMethod logbit$Qu;
    public static final ModuleMethod bit$Mnextract;
    public static final ModuleMethod logand;
    public static final ModuleMethod logior;
    public static final ModuleMethod logxor;
    public static final ModuleMethod logtest;
    public static final ModuleMethod logcount;
    public static final ModuleMethod integer$Mnlength;
    public static final ModuleMethod number$Mn$Grstring;
    public static final ModuleMethod string$Mn$Grnumber;
    public static final ModuleMethod quantity$Mn$Grnumber;
    public static final ModuleMethod quantity$Mn$Grunit;
    public static final ModuleMethod make$Mnquantity;
    public static final ModuleMethod duration;
    static final IntNum Lit0;
    static final IntNum Lit1;
    static ModuleMethod lambda$Fn1;
    static ModuleMethod lambda$Fn2;
    static final IntNum Lit2;
    static final FString Lit3;
    public static final numbers $instance;
    static final Symbol Lit4;
    static final Symbol Lit5;
    static final Symbol Lit6;
    static final Symbol Lit7;
    static final Symbol Lit8;

    public numbers() {
        ModuleInfo.register(this);
    }

    public static boolean isNumber(Object x) {
        return x instanceof Numeric;
    }

    public static boolean isQuantity(Object x) {
        return x instanceof Quantity;
    }

    public static boolean isComplex(Object x) {
        return x instanceof Complex;
    }

    public static boolean isReal(Object x) {
        return x instanceof RealNum;
    }

    public static boolean isRational(Object x) {
        return x instanceof RatNum;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInteger(Object x) {
        boolean bl;
        boolean x2 = x instanceof IntNum;
        if (x2) {
            bl = x2;
            return bl;
        }
        boolean x3 = x instanceof DFloNum;
        if (!x3) {
            void var2_2;
            bl = var2_2;
            return bl;
        }
        Object object2 = x;
        try {
            if (Math.IEEEremainder(((DFloNum)object2).doubleValue(), 1.0) != 0.0) return false;
            return true;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.math.DFloNum.doubleValue()", 1, object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isExact(Object x) {
        void var1_1;
        boolean x2 = x instanceof Numeric;
        return x2 ? ((Numeric)x).isExact() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInexact(Object x) {
        void var1_1;
        boolean x2 = x instanceof Numeric;
        return (x2 ? ((Numeric)x).isExact() + 1 & 1 : var1_1) != 0;
    }

    public static boolean isZero(Numeric x) {
        return x.isZero();
    }

    public static boolean isPositive(RealNum x) {
        return x.sign() > 0;
    }

    public static boolean isNegative(RealNum x) {
        return x.isNegative();
    }

    public static boolean isOdd(IntNum x) {
        return x.isOdd();
    }

    public static boolean isEven(IntNum x) {
        return (numbers.isOdd(x) + 1 & 1) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object max$V(Object[] args) {
        RealNum result;
        Object object3 = args[0];
        try {
            result = (RealNum)object3;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        int n = args.length;
        int i = 1;
        while (i < n) {
            Object object2 = args[i];
            try {
                result = result.max((RealNum)object2);
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.RealNum.max(gnu.math.RealNum)", 2, object2);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object min$V(Object[] args) {
        RealNum result;
        Object object3 = args[0];
        try {
            result = (RealNum)object3;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        int n = args.length;
        int i = 0;
        while (i < n) {
            Object object2 = args[i];
            try {
                result = result.min((RealNum)object2);
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.RealNum.min(gnu.math.RealNum)", 2, object2);
            }
        }
        return result;
    }

    public static Numeric abs(Numeric x) {
        return x.abs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RealNum quotient(RealNum x, RealNum y) {
        RealNum realNum;
        block4: {
            IntNum intNum;
            boolean x2 = x instanceof IntNum;
            if (!(x2 ? y instanceof IntNum : x2)) break block4;
            RealNum realNum2 = x;
            try {
                intNum = (IntNum)realNum2;
                realNum2 = y;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.IntNum.quotient(gnu.math.IntNum,gnu.math.IntNum)", 1, (Object)realNum2);
            }
            try {}
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.IntNum.quotient(gnu.math.IntNum,gnu.math.IntNum)", 2, (Object)realNum2);
            }
            realNum = IntNum.quotient(intNum, (IntNum)realNum2);
            return realNum;
        }
        realNum = RealNum.divide(x, y).toInt(Numeric.TRUNCATE);
        return realNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RealNum remainder(RealNum x, RealNum y) {
        RealNum realNum;
        block6: {
            IntNum intNum;
            boolean x2 = x instanceof IntNum;
            if (!(x2 ? y instanceof IntNum : x2)) break block6;
            RealNum realNum2 = x;
            try {
                intNum = (IntNum)realNum2;
                realNum2 = y;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.IntNum.remainder(gnu.math.IntNum,gnu.math.IntNum)", 1, (Object)realNum2);
            }
            try {}
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.IntNum.remainder(gnu.math.IntNum,gnu.math.IntNum)", 2, (Object)realNum2);
            }
            realNum = IntNum.remainder(intNum, (IntNum)realNum2);
            return realNum;
        }
        if (!numbers.isZero(y)) {
            realNum = (RealNum)((Procedure)AddOp.$Mn).apply2(x, ((Procedure)MultiplyOp.$St).apply2(RealNum.divide(x, y).toInt(Numeric.TRUNCATE), y));
            return realNum;
        }
        if (numbers.isExact(y)) {
            realNum = x;
            return realNum;
        }
        realNum = (RealNum)numbers.exact$To$Inexact(x);
        return realNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RealNum modulo(RealNum x, RealNum y) {
        RealNum realNum;
        block6: {
            IntNum intNum;
            boolean x2 = x instanceof IntNum;
            if (!(x2 ? y instanceof IntNum : x2)) break block6;
            RealNum realNum2 = x;
            try {
                intNum = (IntNum)realNum2;
                realNum2 = y;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.IntNum.modulo(gnu.math.IntNum,gnu.math.IntNum)", 1, (Object)realNum2);
            }
            try {}
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.IntNum.modulo(gnu.math.IntNum,gnu.math.IntNum)", 2, (Object)realNum2);
            }
            realNum = IntNum.modulo(intNum, (IntNum)realNum2);
            return realNum;
        }
        if (!numbers.isZero(y)) {
            realNum = (RealNum)((Procedure)AddOp.$Mn).apply2(x, ((Procedure)MultiplyOp.$St).apply2(RealNum.divide(x, y).toInt(Numeric.FLOOR), y));
            return realNum;
        }
        if (numbers.isExact(y)) {
            realNum = x;
            return realNum;
        }
        realNum = (RealNum)numbers.exact$To$Inexact(x);
        return realNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntNum gcd$V(Object[] args) {
        int i;
        IntNum result;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = Lit0;
            return intNum;
        }
        Object object2 = args[0];
        try {
            result = (IntNum)object2;
            i = 1;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object2);
        }
        while (true) {
            if (i >= n) {
                intNum = result;
                return intNum;
            }
            result = IntNum.gcd(result, (IntNum)args[i]);
            ++i;
        }
    }

    public static IntNum lcm$V(Object[] args) {
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = Lit1;
        } else {
            IntNum result = IntNum.abs((IntNum)args[0]);
            int i = 1;
            while (true) {
                if (i >= n) {
                    intNum = result;
                    break;
                }
                result = IntNum.lcm(result, (IntNum)args[i]);
                ++i;
            }
        }
        return intNum;
    }

    public static IntNum numerator(RatNum x) {
        return x.numerator();
    }

    public static IntNum denominator(RatNum x) {
        return x.denominator();
    }

    public static RealNum floor(RealNum x) {
        return x.toInt(Numeric.FLOOR);
    }

    public static RealNum ceiling(RealNum x) {
        return x.toInt(Numeric.CEILING);
    }

    public static RealNum truncate(RealNum x) {
        return x.toInt(Numeric.TRUNCATE);
    }

    public static RealNum round(RealNum x) {
        return x.toInt(Numeric.ROUND);
    }

    public static RealNum rationalize(RealNum x, RealNum y) {
        return RatNum.rationalize((RealNum)x.sub(y), (RealNum)x.add(y));
    }

    public static Complex exp(Complex x) {
        return x.exp();
    }

    public static Complex log(Complex x) {
        return x.log();
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double tan(double x) {
        return Math.tan(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    static double lambda1(double y, double x) {
        return Math.atan2(y, x);
    }

    static double lambda2(double x) {
        return Math.atan(x);
    }

    public static Quantity sqrt(Quantity num) {
        return Quantity.make(num.number().sqrt(), num.unit().sqrt());
    }

    public static Complex makeRectangular(RealNum x, RealNum y) {
        return Complex.make(x, y);
    }

    public static DComplex makePolar(double x, double y) {
        return Complex.polar(x, y);
    }

    public static RealNum realPart(Complex x) {
        return x.re();
    }

    public static RealNum imagPart(Complex x) {
        return x.im();
    }

    public static Numeric magnitude(Numeric x) {
        return x.abs();
    }

    public static RealNum angle(Complex x) {
        return x.angle();
    }

    public static Numeric exact$To$Inexact(Numeric num) {
        return num.isExact() ? new DFloNum(((RealNum)num).doubleValue()) : num;
    }

    public static Numeric inexact$To$Exact(Numeric num) {
        return num instanceof RealNum ? ((RealNum)num).toExact() : num;
    }

    public static IntNum arithmeticShift(IntNum value, int amount) {
        return IntNum.shift(value, amount);
    }

    public static IntNum lognot(IntNum i) {
        return BitOps.not(i);
    }

    public static IntNum logop(int op, IntNum i, IntNum j) {
        return BitOps.bitOp(op, i, j);
    }

    public static boolean isLogbit(IntNum i, int bitno) {
        return BitOps.bitValue(i, bitno);
    }

    public static IntNum bitExtract(IntNum i, int start, int end) {
        return BitOps.extract(i, start, end);
    }

    /*
     * Loose catch block
     */
    public static IntNum logand$V(Object[] args) {
        Object object2;
        Object object3;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = Lit2;
        } else {
            object3 = args[0];
            IntNum result = (IntNum)object3;
            int i = 1;
            while (true) {
                if (i >= n) {
                    intNum = result;
                    break;
                }
                object2 = args[i];
                IntNum arg$Mni = (IntNum)object2;
                result = BitOps.and(result, arg$Mni);
                ++i;
            }
        }
        return intNum;
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntNum logior$V(Object[] args) {
        int i;
        IntNum result;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = Lit0;
            return intNum;
        }
        Object object3 = args[0];
        try {
            result = (IntNum)object3;
            i = 1;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        while (true) {
            if (i >= n) {
                intNum = result;
                return intNum;
            }
            Object object2 = args[i];
            try {
                result = BitOps.ior(result, (IntNum)object2);
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.BitOps.ior(gnu.math.IntNum,gnu.math.IntNum)", 2, object2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntNum logxor$V(Object[] args) {
        int i;
        IntNum result;
        IntNum intNum;
        int n = args.length;
        if (numbers.isZero(IntNum.make(n))) {
            intNum = Lit0;
            return intNum;
        }
        Object object3 = args[0];
        try {
            result = (IntNum)object3;
            i = 1;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object3);
        }
        while (true) {
            if (i >= n) {
                intNum = result;
                return intNum;
            }
            Object object2 = args[i];
            try {
                result = BitOps.xor(result, (IntNum)object2);
                ++i;
            }
            catch (ClassCastException classCastException) {
                throw new WrongType(classCastException, "gnu.math.BitOps.xor(gnu.math.IntNum,gnu.math.IntNum)", 2, object2);
            }
        }
    }

    public static boolean logtest(IntNum i, IntNum j) {
        return BitOps.test(i, j);
    }

    public static int logcount(IntNum i) {
        return BitOps.bitCount(i);
    }

    public static int integerLength(IntNum i) {
        return i.intLength();
    }

    public static FString number$To$String(Number number) {
        return numbers.number$To$String(number, 10);
    }

    public static FString number$To$String(Number arg, int radix) {
        return new FString(Arithmetic.toString(arg, radix));
    }

    public static Object string$To$Number(FString fString) {
        return numbers.string$To$Number(fString, 10);
    }

    public static Object string$To$Number(FString str, int radix) {
        Object result = LispReader.parseNumber(str.data, 0, str.length(), '\u0000', radix, LispReader.SCM_NUMBERS);
        return result instanceof Numeric ? result : Boolean.FALSE;
    }

    public static Complex quantity$To$Number(Quantity q) {
        q.unit();
        double factor = q.doubleValue();
        return factor == 1.0 ? q.number() : Complex.make(q.reValue(), q.imValue());
    }

    public static Unit quantity$To$Unit(Quantity q) {
        return q.unit();
    }

    /*
     * Loose catch block
     */
    public static Quantity makeQuantity(Object val, Object unit) {
        Unit u;
        Unit unit2;
        Object object2;
        if (unit instanceof Unit) {
            object2 = unit;
            unit2 = (Unit)object2;
        }
        Object object3 = unit;
        unit2 = u = Unit.lookup((String)(object3 == null ? null : object3.toString()));
        if (u == null) {
            throw (Throwable)new IllegalArgumentException(Format.format$V(new Object[]{Lit3, unit}).toString());
        }
        object2 = val;
        try {
            return Quantity.make((Complex)object2, u);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.math.Quantity.make(gnu.math.Complex,gnu.math.Unit)", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, null, -4, object2);
        }
    }

    public static Duration duration(Object duration) {
        Object object2 = duration;
        return Duration.parseDuration((String)(object2 == null ? null : object2.toString()));
    }

    public final void run(CallContext $ctx) {
        Consumer $result = $ctx.consumer;
        Object object2 = require.find("kawa.lib.prim_syntax");
        try {
            ((Runnable)object2).run();
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "java.lang.Runnable.run()", 1, object2);
        }
        object2 = require.find("kawa.lib.std_syntax");
        try {
            ((Runnable)object2).run();
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "java.lang.Runnable.run()", 1, object2);
        }
        object2 = require.find("kawa.lib.syntax");
        try {
            ((Runnable)object2).run();
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "java.lang.Runnable.run()", 1, object2);
        }
        syntax.addProcedureProperties$V(atan, new Object[]{lambda$Fn1, lambda$Fn2});
    }

    static {
        Lit8 = Symbol.make(Namespace.EmptyNamespace, "<java.lang.IllegalArgumentException>");
        Lit7 = Symbol.make(Namespace.EmptyNamespace, "<string>");
        Lit6 = Symbol.make(Namespace.EmptyNamespace, "<gnu.math.DFloNum>");
        Lit5 = Symbol.make(Namespace.EmptyNamespace, "<gnu.expr.GenericProc>");
        Lit4 = Symbol.make(Namespace.EmptyNamespace, "<number>");
        Lit3 = new FString("unknown unit: ~s");
        Lit2 = IntNum.make(-1);
        Lit1 = IntNum.make(1);
        Lit0 = IntNum.make(0);
        $instance = new numbers();
        loc$$Lsnumber$Gr = ThreadLocation.getInstance(Lit4, null);
        loc$$Lsgnu$Dtexpr$DtGenericProc$Gr = ThreadLocation.getInstance(Lit5, null);
        loc$$Lsgnu$Dtmath$DtDFloNum$Gr = ThreadLocation.getInstance(Lit6, null);
        loc$$Lsstring$Gr = ThreadLocation.getInstance(Lit7, null);
        loc$$Lsjava$Dtlang$DtIllegalArgumentException$Gr = ThreadLocation.getInstance(Lit8, null);
        atan = new GenericProc("atan");
        numbers numbers2 = $instance;
        number$Qu = new ModuleMethod(numbers2, 1, "number?", 4097);
        quantity$Qu = new ModuleMethod(numbers2, 2, "quantity?", 4097);
        complex$Qu = new ModuleMethod(numbers2, 3, "complex?", 4097);
        real$Qu = new ModuleMethod(numbers2, 4, "real?", 4097);
        rational$Qu = new ModuleMethod(numbers2, 5, "rational?", 4097);
        integer$Qu = new ModuleMethod(numbers2, 6, "integer?", 4097);
        exact$Qu = new ModuleMethod(numbers2, 7, "exact?", 4097);
        inexact$Qu = new ModuleMethod(numbers2, 8, "inexact?", 4097);
        zero$Qu = new ModuleMethod(numbers2, 9, "zero?", 4097);
        positive$Qu = new ModuleMethod(numbers2, 10, "positive?", 4097);
        negative$Qu = new ModuleMethod(numbers2, 11, "negative?", 4097);
        odd$Qu = new ModuleMethod(numbers2, 12, "odd?", 4097);
        even$Qu = new ModuleMethod(numbers2, 13, "even?", 4097);
        max = new ModuleMethod(numbers2, 14, "max", -4096);
        min = new ModuleMethod(numbers2, 15, "min", -4096);
        abs = new ModuleMethod(numbers2, 16, "abs", 4097);
        quotient = new ModuleMethod(numbers2, 17, "quotient", 8194);
        remainder = new ModuleMethod(numbers2, 18, "remainder", 8194);
        modulo = new ModuleMethod(numbers2, 19, "modulo", 8194);
        gcd = new ModuleMethod(numbers2, 20, "gcd", -4096);
        lcm = new ModuleMethod(numbers2, 21, "lcm", -4096);
        numerator = new ModuleMethod(numbers2, 22, "numerator", 4097);
        denominator = new ModuleMethod(numbers2, 23, "denominator", 4097);
        floor = new ModuleMethod(numbers2, 24, "floor", 4097);
        ceiling = new ModuleMethod(numbers2, 25, "ceiling", 4097);
        truncate = new ModuleMethod(numbers2, 26, "truncate", 4097);
        round = new ModuleMethod(numbers2, 27, "round", 4097);
        rationalize = new ModuleMethod(numbers2, 28, "rationalize", 8194);
        exp = new ModuleMethod(numbers2, 29, "exp", 4097);
        log = new ModuleMethod(numbers2, 30, "log", 4097);
        sin = new ModuleMethod(numbers2, 31, "sin", 4097);
        cos = new ModuleMethod(numbers2, 32, "cos", 4097);
        tan = new ModuleMethod(numbers2, 33, "tan", 4097);
        asin = new ModuleMethod(numbers2, 34, "asin", 4097);
        acos = new ModuleMethod(numbers2, 35, "acos", 4097);
        ModuleMethod moduleMethod = new ModuleMethod(numbers2, 36, null, 8194);
        moduleMethod.setProperty("source-location", "/home/bothner/Kawa/head/kawa/lib/numbers.scm:144");
        lambda$Fn1 = moduleMethod;
        ModuleMethod moduleMethod2 = new ModuleMethod(numbers2, 37, null, 4097);
        moduleMethod2.setProperty("source-location", "/home/bothner/Kawa/head/kawa/lib/numbers.scm:146");
        lambda$Fn2 = moduleMethod2;
        sqrt = new ModuleMethod(numbers2, 38, "sqrt", 4097);
        make$Mnrectangular = new ModuleMethod(numbers2, 39, "make-rectangular", 8194);
        make$Mnpolar = new ModuleMethod(numbers2, 40, "make-polar", 8194);
        real$Mnpart = new ModuleMethod(numbers2, 41, "real-part", 4097);
        imag$Mnpart = new ModuleMethod(numbers2, 42, "imag-part", 4097);
        magnitude = new ModuleMethod(numbers2, 43, "magnitude", 4097);
        angle = new ModuleMethod(numbers2, 44, "angle", 4097);
        exact$Mn$Grinexact = new ModuleMethod(numbers2, 45, "exact->inexact", 4097);
        inexact$Mn$Grexact = new ModuleMethod(numbers2, 46, "inexact->exact", 4097);
        arithmetic$Mnshift = new ModuleMethod(numbers2, 47, "arithmetic-shift", 8194);
        lognot = new ModuleMethod(numbers2, 48, "lognot", 4097);
        logop = new ModuleMethod(numbers2, 49, "logop", 12291);
        logbit$Qu = new ModuleMethod(numbers2, 50, "logbit?", 8194);
        bit$Mnextract = new ModuleMethod(numbers2, 51, "bit-extract", 12291);
        logand = new ModuleMethod(numbers2, 52, "logand", -4096);
        logior = new ModuleMethod(numbers2, 53, "logior", -4096);
        logxor = new ModuleMethod(numbers2, 54, "logxor", -4096);
        logtest = new ModuleMethod(numbers2, 55, "logtest", 8194);
        logcount = new ModuleMethod(numbers2, 56, "logcount", 4097);
        integer$Mnlength = new ModuleMethod(numbers2, 57, "integer-length", 4097);
        number$Mn$Grstring = new ModuleMethod(numbers2, 58, "number->string", 8193);
        string$Mn$Grnumber = new ModuleMethod(numbers2, 60, "string->number", 8193);
        quantity$Mn$Grnumber = new ModuleMethod(numbers2, 62, "quantity->number", 4097);
        quantity$Mn$Grunit = new ModuleMethod(numbers2, 63, "quantity->unit", 4097);
        make$Mnquantity = new ModuleMethod(numbers2, 64, "make-quantity", 8194);
        duration = new ModuleMethod(numbers2, 65, "duration", 4097);
        $instance.run();
    }

    public int match1(ModuleMethod moduleMethod, Object object2, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 65: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 63: {
                Object object3 = object2;
                if (!(object3 instanceof Quantity)) {
                    return -786431;
                }
                callContext.value1 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 62: {
                Object object4 = object2;
                if (!(object4 instanceof Quantity)) {
                    return -786431;
                }
                callContext.value1 = object4;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 60: {
                Object object5 = object2;
                if (!(object5 instanceof FString)) {
                    return -786431;
                }
                callContext.value1 = object5;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 58: {
                Object object6 = object2;
                if (!(object6 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object6;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 57: {
                Object object7 = object2;
                if (!(object7 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 56: {
                Object object8 = object2;
                if (!(object8 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object8;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 48: {
                Object object9 = object2;
                if (!(object9 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object9;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 46: {
                Object object10 = object2;
                if (!(object10 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object10;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 45: {
                Object object11 = object2;
                if (!(object11 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object11;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 44: {
                Object object12 = object2;
                if (!(object12 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object12;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 43: {
                Object object13 = object2;
                if (!(object13 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object13;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 42: {
                Object object14 = object2;
                if (!(object14 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object14;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 41: {
                Object object15 = object2;
                if (!(object15 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object15;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 38: {
                Object object16 = object2;
                if (!(object16 instanceof Quantity)) {
                    return -786431;
                }
                callContext.value1 = object16;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 37: {
                Object object17 = object2;
                if (!(object17 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object17;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 35: {
                Object object18 = object2;
                if (!(object18 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object18;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 34: {
                Object object19 = object2;
                if (!(object19 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object19;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 33: {
                Object object20 = object2;
                if (!(object20 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object20;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 32: {
                Object object21 = object2;
                if (!(object21 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object21;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 31: {
                Object object22 = object2;
                if (!(object22 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object22;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 30: {
                Object object23 = object2;
                if (!(object23 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object23;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 29: {
                Object object24 = object2;
                if (!(object24 instanceof Complex)) {
                    return -786431;
                }
                callContext.value1 = object24;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 27: {
                Object object25 = object2;
                if (!(object25 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object25;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 26: {
                Object object26 = object2;
                if (!(object26 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object26;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 25: {
                Object object27 = object2;
                if (!(object27 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object27;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 24: {
                Object object28 = object2;
                if (!(object28 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object28;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 23: {
                Object object29 = object2;
                if (!(object29 instanceof RatNum)) {
                    return -786431;
                }
                callContext.value1 = object29;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 22: {
                Object object30 = object2;
                if (!(object30 instanceof RatNum)) {
                    return -786431;
                }
                callContext.value1 = object30;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 16: {
                Object object31 = object2;
                if (!(object31 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object31;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 13: {
                Object object32 = object2;
                if (!(object32 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object32;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 12: {
                Object object33 = object2;
                if (!(object33 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object33;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 11: {
                Object object34 = object2;
                if (!(object34 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object34;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 10: {
                Object object35 = object2;
                if (!(object35 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object35;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 9: {
                Object object36 = object2;
                if (!(object36 instanceof Numeric)) {
                    return -786431;
                }
                callContext.value1 = object36;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 8: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 7: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 6: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 5: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 4: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 3: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 2: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 1: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
        }
        return super.match1(moduleMethod, object2, callContext);
    }

    public int match2(ModuleMethod moduleMethod, Object object2, Object object3, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 64: {
                callContext.value1 = object2;
                callContext.value2 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 60: {
                Object object4 = object2;
                if (!(object4 instanceof FString)) {
                    return -786431;
                }
                callContext.value1 = object4;
                Object object5 = object3;
                if (!(object5 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object5;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 58: {
                Object object6 = object2;
                if (!(object6 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object6;
                Object object7 = object3;
                if (!(object7 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 55: {
                Object object8 = object2;
                if (!(object8 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object8;
                Object object9 = object3;
                if (!(object9 instanceof IntNum)) {
                    return -786430;
                }
                callContext.value2 = object9;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 50: {
                Object object10 = object2;
                if (!(object10 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object10;
                Object object11 = object3;
                if (!(object11 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object11;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 47: {
                Object object12 = object2;
                if (!(object12 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object12;
                Object object13 = object3;
                if (!(object13 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object13;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 40: {
                Object object14 = object2;
                if (!(object14 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object14;
                Object object15 = object3;
                if (!(object15 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object15;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 39: {
                Object object16 = object2;
                if (!(object16 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object16;
                Object object17 = object3;
                if (!(object17 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object17;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 36: {
                Object object18 = object2;
                if (!(object18 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object18;
                Object object19 = object3;
                if (!(object19 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object19;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 28: {
                Object object20 = object2;
                if (!(object20 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object20;
                Object object21 = object3;
                if (!(object21 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object21;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 19: {
                Object object22 = object2;
                if (!(object22 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object22;
                Object object23 = object3;
                if (!(object23 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object23;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 18: {
                Object object24 = object2;
                if (!(object24 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object24;
                Object object25 = object3;
                if (!(object25 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object25;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 17: {
                Object object26 = object2;
                if (!(object26 instanceof RealNum)) {
                    return -786431;
                }
                callContext.value1 = object26;
                Object object27 = object3;
                if (!(object27 instanceof RealNum)) {
                    return -786430;
                }
                callContext.value2 = object27;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
        }
        return super.match2(moduleMethod, object2, object3, callContext);
    }

    public int match3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 51: {
                Object object5 = object2;
                if (!(object5 instanceof IntNum)) {
                    return -786431;
                }
                callContext.value1 = object5;
                Object object6 = object3;
                if (!(object6 instanceof Number)) {
                    return -786430;
                }
                callContext.value2 = object6;
                Object object7 = object4;
                if (!(object7 instanceof Number)) {
                    return -786429;
                }
                callContext.value3 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 3;
                return 0;
            }
            case 49: {
                Object object8 = object2;
                if (!(object8 instanceof Number)) {
                    return -786431;
                }
                callContext.value1 = object8;
                Object object9 = object3;
                if (!(object9 instanceof IntNum)) {
                    return -786430;
                }
                callContext.value2 = object9;
                Object object10 = object4;
                if (!(object10 instanceof IntNum)) {
                    return -786429;
                }
                callContext.value3 = object10;
                callContext.proc = moduleMethod;
                callContext.pc = 3;
                return 0;
            }
        }
        return super.match3(moduleMethod, object2, object3, object4, callContext);
    }

    public int matchN(ModuleMethod moduleMethod, Object[] objectArray, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 54: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 53: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 52: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 21: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 20: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 15: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
            case 14: {
                callContext.values = objectArray;
                callContext.proc = moduleMethod;
                callContext.pc = 5;
                return 0;
            }
        }
        return super.matchN(moduleMethod, objectArray, callContext);
    }

    /*
     * Loose catch block
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 65: {
                return numbers.duration(object2);
            }
            case 63: {
                return numbers.quantity$To$Unit((Quantity)object2);
            }
            case 62: {
                return numbers.quantity$To$Number((Quantity)object2);
            }
            case 60: {
                return numbers.string$To$Number((FString)object2);
            }
            case 58: {
                return numbers.number$To$String((Number)object2);
            }
            case 57: {
                return IntNum.make(numbers.integerLength((IntNum)object2));
            }
            case 56: {
                return IntNum.make(numbers.logcount((IntNum)object2));
            }
            case 48: {
                return numbers.lognot((IntNum)object2);
            }
            case 46: {
                return numbers.inexact$To$Exact((Numeric)object2);
            }
            case 45: {
                return numbers.exact$To$Inexact((Numeric)object2);
            }
            case 44: {
                return numbers.angle((Complex)object2);
            }
            case 43: {
                return numbers.magnitude((Numeric)object2);
            }
            case 42: {
                return numbers.imagPart((Complex)object2);
            }
            case 41: {
                return numbers.realPart((Complex)object2);
            }
            case 38: {
                return numbers.sqrt((Quantity)object2);
            }
            case 37: {
                return DFloNum.make(numbers.lambda2(((Number)object2).doubleValue()));
            }
            case 35: {
                return DFloNum.make(numbers.acos(((Number)object2).doubleValue()));
            }
            case 34: {
                return DFloNum.make(numbers.asin(((Number)object2).doubleValue()));
            }
            case 33: {
                return DFloNum.make(numbers.tan(((Number)object2).doubleValue()));
            }
            case 32: {
                return DFloNum.make(numbers.cos(((Number)object2).doubleValue()));
            }
            case 31: {
                return DFloNum.make(numbers.sin(((Number)object2).doubleValue()));
            }
            case 30: {
                return numbers.log((Complex)object2);
            }
            case 29: {
                return numbers.exp((Complex)object2);
            }
            case 27: {
                return numbers.round((RealNum)object2);
            }
            case 26: {
                return numbers.truncate((RealNum)object2);
            }
            case 25: {
                return numbers.ceiling((RealNum)object2);
            }
            case 24: {
                return numbers.floor((RealNum)object2);
            }
            case 23: {
                return numbers.denominator((RatNum)object2);
            }
            case 22: {
                return numbers.numerator((RatNum)object2);
            }
            case 16: {
                return numbers.abs((Numeric)object2);
            }
            case 13: {
                return numbers.isEven((IntNum)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return numbers.isOdd((IntNum)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return numbers.isNegative((RealNum)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return numbers.isPositive((RealNum)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return numbers.isZero((Numeric)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return numbers.isInexact(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return numbers.isExact(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return numbers.isInteger(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return numbers.isRational(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return numbers.isReal(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return numbers.isComplex(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return numbers.isQuantity(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return numbers.isNumber(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "quantity->unit", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "quantity->number", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "string->number", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "number->string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "integer-length", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logcount", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lognot", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "inexact->exact", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "exact->inexact", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "angle", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "magnitude", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "imag-part", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "real-part", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "sqrt", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "acos", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "asin", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "tan", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "cos", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "sin", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "log", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "exp", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "round", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "truncate", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "ceiling", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "floor", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "denominator", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "numerator", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "abs", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "even?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "odd?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "negative?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "positive?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "zero?", 1, object2);
        }
    }

    /*
     * Loose catch block
     */
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 64: {
                return numbers.makeQuantity(object2, object3);
            }
            case 60: {
                FString fString = (FString)object2;
                return numbers.string$To$Number(fString, ((Number)object3).intValue());
            }
            case 58: {
                Number number = (Number)object2;
                return numbers.number$To$String(number, ((Number)object3).intValue());
            }
            case 55: {
                IntNum intNum = (IntNum)object2;
                return numbers.logtest(intNum, (IntNum)object3) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 50: {
                IntNum intNum = (IntNum)object2;
                return numbers.isLogbit(intNum, ((Number)object3).intValue()) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 47: {
                IntNum intNum = (IntNum)object2;
                return numbers.arithmeticShift(intNum, ((Number)object3).intValue());
            }
            case 40: {
                double d = ((Number)object2).doubleValue();
                return numbers.makePolar(d, ((Number)object3).doubleValue());
            }
            case 39: {
                RealNum realNum = (RealNum)object2;
                return numbers.makeRectangular(realNum, (RealNum)object3);
            }
            case 36: {
                double d = ((Number)object2).doubleValue();
                return DFloNum.make(numbers.lambda1(d, ((Number)object3).doubleValue()));
            }
            case 28: {
                RealNum realNum = (RealNum)object2;
                return numbers.rationalize(realNum, (RealNum)object3);
            }
            case 19: {
                RealNum realNum = (RealNum)object2;
                return numbers.modulo(realNum, (RealNum)object3);
            }
            case 18: {
                RealNum realNum = (RealNum)object2;
                return numbers.remainder(realNum, (RealNum)object3);
            }
            case 17: {
                RealNum realNum = (RealNum)object2;
                return numbers.quotient(realNum, (RealNum)object3);
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "string->number", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "string->number", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "number->string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "number->string", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logtest", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logtest", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logbit?", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logbit?", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "arithmetic-shift", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "arithmetic-shift", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-polar", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-polar", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-rectangular", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "make-rectangular", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "lambda", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "rationalize", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "rationalize", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "modulo", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "modulo", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "remainder", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "remainder", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "quotient", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "quotient", 2, object3);
        }
    }

    /*
     * Loose catch block
     */
    public Object apply3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4) {
        switch (moduleMethod.selector) {
            case 51: {
                IntNum intNum = (IntNum)object2;
                int n = ((Number)object3).intValue();
                return numbers.bitExtract(intNum, n, ((Number)object4).intValue());
            }
            case 49: {
                int n = ((Number)object2).intValue();
                IntNum intNum = (IntNum)object3;
                return numbers.logop(n, intNum, (IntNum)object4);
            }
        }
        return super.apply3(moduleMethod, object2, object3, object4);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bit-extract", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bit-extract", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "bit-extract", 3, object4);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logop", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logop", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "logop", 3, object4);
        }
    }

    public Object applyN(ModuleMethod moduleMethod, Object[] objectArray) {
        switch (moduleMethod.selector) {
            case 54: {
                return numbers.logxor$V(objectArray);
            }
            case 53: {
                return numbers.logior$V(objectArray);
            }
            case 52: {
                return numbers.logand$V(objectArray);
            }
            case 21: {
                return numbers.lcm$V(objectArray);
            }
            case 20: {
                return numbers.gcd$V(objectArray);
            }
            case 15: {
                return numbers.min$V(objectArray);
            }
            case 14: {
                return numbers.max$V(objectArray);
            }
        }
        return super.applyN(moduleMethod, objectArray);
    }
}

