// GENERATED FILE - DO NOT EDIT.
// Generated by gen_spirv_builder_and_parser.py using data from spirv.core.grammar.json.
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// spirv_instruction_builder_autogen.h:
//   Functions to generate SPIR-V binary for each instruction.

#ifndef COMMON_SPIRV_SPIRVINSTRUCTIONBUILDERAUTOGEN_H_
#define COMMON_SPIRV_SPIRVINSTRUCTIONBUILDERAUTOGEN_H_

#include <spirv/unified1/spirv.hpp>

#include "spirv_types.h"

namespace angle
{
namespace spirv
{

void WriteSpirvHeader(std::vector<uint32_t> *blob, uint32_t idCount);
void WriteNop(Blob *blob);
void WriteUndef(Blob *blob, IdResultType idResultType, IdResult idResult);
void WriteSourceContinued(Blob *blob, LiteralString continuedSource);
void WriteSource(Blob *blob,
                 spv::SourceLanguage sourceLanguage,
                 LiteralInteger version,
                 const IdRef *file,
                 const LiteralString *source);
void WriteSourceExtension(Blob *blob, LiteralString extension);
void WriteName(Blob *blob, IdRef target, LiteralString name);
void WriteMemberName(Blob *blob, IdRef type, LiteralInteger member, LiteralString name);
void WriteString(Blob *blob, IdResult idResult, LiteralString string);
void WriteLine(Blob *blob, IdRef file, LiteralInteger line, LiteralInteger column);
void WriteExtension(Blob *blob, LiteralString name);
void WriteExtInstImport(Blob *blob, IdResult idResult, LiteralString name);
void WriteExtInst(Blob *blob,
                  IdResultType idResultType,
                  IdResult idResult,
                  IdRef set,
                  LiteralExtInstInteger instruction,
                  const IdRefList &operandList);
void WriteMemoryModel(Blob *blob,
                      spv::AddressingModel addressingModel,
                      spv::MemoryModel memoryModel);
void WriteEntryPoint(Blob *blob,
                     spv::ExecutionModel executionModel,
                     IdRef entryPoint,
                     LiteralString name,
                     const IdRefList &interfaceList);
void WriteExecutionMode(Blob *blob,
                        IdRef entryPoint,
                        spv::ExecutionMode mode,
                        const LiteralIntegerList &operandsList);
void WriteCapability(Blob *blob, spv::Capability capability);
void WriteTypeVoid(Blob *blob, IdResult idResult);
void WriteTypeBool(Blob *blob, IdResult idResult);
void WriteTypeInt(Blob *blob, IdResult idResult, LiteralInteger width, LiteralInteger signedness);
void WriteTypeFloat(Blob *blob, IdResult idResult, LiteralInteger width);
void WriteTypeVector(Blob *blob,
                     IdResult idResult,
                     IdRef componentType,
                     LiteralInteger componentCount);
void WriteTypeMatrix(Blob *blob, IdResult idResult, IdRef columnType, LiteralInteger columnCount);
void WriteTypeImage(Blob *blob,
                    IdResult idResult,
                    IdRef sampledType,
                    spv::Dim dim,
                    LiteralInteger depth,
                    LiteralInteger arrayed,
                    LiteralInteger mS,
                    LiteralInteger sampled,
                    spv::ImageFormat imageFormat,
                    const spv::AccessQualifier *accessQualifier);
void WriteTypeSampler(Blob *blob, IdResult idResult);
void WriteTypeSampledImage(Blob *blob, IdResult idResult, IdRef imageType);
void WriteTypeArray(Blob *blob, IdResult idResult, IdRef elementType, IdRef length);
void WriteTypeRuntimeArray(Blob *blob, IdResult idResult, IdRef elementType);
void WriteTypeStruct(Blob *blob, IdResult idResult, const IdRefList &memberList);
void WriteTypePointer(Blob *blob, IdResult idResult, spv::StorageClass storageClass, IdRef type);
void WriteTypeFunction(Blob *blob,
                       IdResult idResult,
                       IdRef returnType,
                       const IdRefList &parameterList);
void WriteConstantTrue(Blob *blob, IdResultType idResultType, IdResult idResult);
void WriteConstantFalse(Blob *blob, IdResultType idResultType, IdResult idResult);
void WriteConstant(Blob *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   LiteralContextDependentNumber value);
void WriteConstantComposite(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            const IdRefList &constituentsList);
void WriteConstantNull(Blob *blob, IdResultType idResultType, IdResult idResult);
void WriteSpecConstantTrue(Blob *blob, IdResultType idResultType, IdResult idResult);
void WriteSpecConstantFalse(Blob *blob, IdResultType idResultType, IdResult idResult);
void WriteSpecConstant(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       LiteralContextDependentNumber value);
void WriteSpecConstantComposite(Blob *blob,
                                IdResultType idResultType,
                                IdResult idResult,
                                const IdRefList &constituentsList);
void WriteFunction(Blob *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   spv::FunctionControlMask functionControl,
                   IdRef functionType);
void WriteFunctionParameter(Blob *blob, IdResultType idResultType, IdResult idResult);
void WriteFunctionEnd(Blob *blob);
void WriteFunctionCall(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef function,
                       const IdRefList &argumentList);
void WriteVariable(Blob *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   spv::StorageClass storageClass,
                   const IdRef *initializer);
void WriteImageTexelPointer(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef image,
                            IdRef coordinate,
                            IdRef sample);
void WriteLoad(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef pointer,
               const spv::MemoryAccessMask *memoryAccess);
void WriteStore(Blob *blob, IdRef pointer, IdRef object, const spv::MemoryAccessMask *memoryAccess);
void WriteCopyMemory(Blob *blob,
                     IdRef target,
                     IdRef source,
                     const spv::MemoryAccessMask *memoryAccess);
void WriteAccessChain(Blob *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef base,
                      const IdRefList &indexesList);
void WriteInBoundsAccessChain(Blob *blob,
                              IdResultType idResultType,
                              IdResult idResult,
                              IdRef base,
                              const IdRefList &indexesList);
void WriteArrayLength(Blob *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef structure,
                      LiteralInteger arraymember);
void WriteDecorate(Blob *blob,
                   IdRef target,
                   spv::Decoration decoration,
                   const LiteralIntegerList &valuesList);
void WriteMemberDecorate(Blob *blob,
                         IdRef structureType,
                         LiteralInteger member,
                         spv::Decoration decoration,
                         const LiteralIntegerList &valuesList);
void WriteDecorationGroup(Blob *blob, IdResult idResult);
void WriteGroupDecorate(Blob *blob, IdRef decorationGroup, const IdRefList &targetsList);
void WriteGroupMemberDecorate(Blob *blob,
                              IdRef decorationGroup,
                              const PairIdRefLiteralIntegerList &targetsPairList);
void WriteVectorExtractDynamic(Blob *blob,
                               IdResultType idResultType,
                               IdResult idResult,
                               IdRef vector,
                               IdRef index);
void WriteVectorInsertDynamic(Blob *blob,
                              IdResultType idResultType,
                              IdResult idResult,
                              IdRef vector,
                              IdRef component,
                              IdRef index);
void WriteVectorShuffle(Blob *blob,
                        IdResultType idResultType,
                        IdResult idResult,
                        IdRef vector1,
                        IdRef vector2,
                        const LiteralIntegerList &componentsList);
void WriteCompositeConstruct(Blob *blob,
                             IdResultType idResultType,
                             IdResult idResult,
                             const IdRefList &constituentsList);
void WriteCompositeExtract(Blob *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef composite,
                           const LiteralIntegerList &indexesList);
void WriteCompositeInsert(Blob *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef object,
                          IdRef composite,
                          const LiteralIntegerList &indexesList);
void WriteCopyObject(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef operand);
void WriteTranspose(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef matrix);
void WriteSampledImage(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef image,
                       IdRef sampler);
void WriteImageSampleImplicitLod(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 const spv::ImageOperandsMask *imageOperands,
                                 const IdRefList &imageOperandIdsList);
void WriteImageSampleExplicitLod(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 spv::ImageOperandsMask imageOperands,
                                 const IdRefList &imageOperandIdsList);
void WriteImageSampleDrefImplicitLod(Blob *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     const spv::ImageOperandsMask *imageOperands,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleDrefExplicitLod(Blob *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     spv::ImageOperandsMask imageOperands,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleProjImplicitLod(Blob *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     const spv::ImageOperandsMask *imageOperands,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleProjExplicitLod(Blob *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     spv::ImageOperandsMask imageOperands,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleProjDrefImplicitLod(Blob *blob,
                                         IdResultType idResultType,
                                         IdResult idResult,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         const spv::ImageOperandsMask *imageOperands,
                                         const IdRefList &imageOperandIdsList);
void WriteImageSampleProjDrefExplicitLod(Blob *blob,
                                         IdResultType idResultType,
                                         IdResult idResult,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         spv::ImageOperandsMask imageOperands,
                                         const IdRefList &imageOperandIdsList);
void WriteImageFetch(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef image,
                     IdRef coordinate,
                     const spv::ImageOperandsMask *imageOperands,
                     const IdRefList &imageOperandIdsList);
void WriteImageGather(Blob *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef sampledImage,
                      IdRef coordinate,
                      IdRef component,
                      const spv::ImageOperandsMask *imageOperands,
                      const IdRefList &imageOperandIdsList);
void WriteImageDrefGather(Blob *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef sampledImage,
                          IdRef coordinate,
                          IdRef dref,
                          const spv::ImageOperandsMask *imageOperands,
                          const IdRefList &imageOperandIdsList);
void WriteImageRead(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef image,
                    IdRef coordinate,
                    const spv::ImageOperandsMask *imageOperands,
                    const IdRefList &imageOperandIdsList);
void WriteImageWrite(Blob *blob,
                     IdRef image,
                     IdRef coordinate,
                     IdRef texel,
                     const spv::ImageOperandsMask *imageOperands,
                     const IdRefList &imageOperandIdsList);
void WriteImage(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef sampledImage);
void WriteImageQuerySizeLod(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef image,
                            IdRef levelofDetail);
void WriteImageQuerySize(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef image);
void WriteImageQueryLod(Blob *blob,
                        IdResultType idResultType,
                        IdResult idResult,
                        IdRef sampledImage,
                        IdRef coordinate);
void WriteImageQueryLevels(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef image);
void WriteImageQuerySamples(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef image);
void WriteConvertFToU(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef floatValue);
void WriteConvertFToS(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef floatValue);
void WriteConvertSToF(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef signedValue);
void WriteConvertUToF(Blob *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef unsignedValue);
void WriteUConvert(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef unsignedValue);
void WriteSConvert(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef signedValue);
void WriteFConvert(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef floatValue);
void WriteQuantizeToF16(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef value);
void WriteBitcast(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef operand);
void WriteSNegate(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef operand);
void WriteFNegate(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef operand);
void WriteIAdd(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteFAdd(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteISub(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteFSub(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteIMul(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteFMul(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteUDiv(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteSDiv(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteFDiv(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteUMod(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteSRem(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteSMod(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteFRem(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteFMod(Blob *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2);
void WriteVectorTimesScalar(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef vector,
                            IdRef scalar);
void WriteMatrixTimesScalar(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef matrix,
                            IdRef scalar);
void WriteVectorTimesMatrix(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef vector,
                            IdRef matrix);
void WriteMatrixTimesVector(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef matrix,
                            IdRef vector);
void WriteMatrixTimesMatrix(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef leftMatrix,
                            IdRef rightMatrix);
void WriteOuterProduct(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef vector1,
                       IdRef vector2);
void WriteDot(Blob *blob,
              IdResultType idResultType,
              IdResult idResult,
              IdRef vector1,
              IdRef vector2);
void WriteIAddCarry(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2);
void WriteISubBorrow(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2);
void WriteUMulExtended(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2);
void WriteSMulExtended(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2);
void WriteAny(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef vector);
void WriteAll(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef vector);
void WriteIsNan(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef x);
void WriteIsInf(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef x);
void WriteLogicalEqual(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2);
void WriteLogicalNotEqual(Blob *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef operand1,
                          IdRef operand2);
void WriteLogicalOr(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2);
void WriteLogicalAnd(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2);
void WriteLogicalNot(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef operand);
void WriteSelect(Blob *blob,
                 IdResultType idResultType,
                 IdResult idResult,
                 IdRef condition,
                 IdRef object1,
                 IdRef object2);
void WriteIEqual(Blob *blob,
                 IdResultType idResultType,
                 IdResult idResult,
                 IdRef operand1,
                 IdRef operand2);
void WriteINotEqual(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2);
void WriteUGreaterThan(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2);
void WriteSGreaterThan(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2);
void WriteUGreaterThanEqual(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2);
void WriteSGreaterThanEqual(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2);
void WriteULessThan(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2);
void WriteSLessThan(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2);
void WriteULessThanEqual(Blob *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2);
void WriteSLessThanEqual(Blob *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2);
void WriteFOrdEqual(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2);
void WriteFUnordEqual(Blob *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef operand1,
                      IdRef operand2);
void WriteFOrdNotEqual(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2);
void WriteFUnordNotEqual(Blob *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2);
void WriteFOrdLessThan(Blob *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2);
void WriteFUnordLessThan(Blob *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2);
void WriteFOrdGreaterThan(Blob *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef operand1,
                          IdRef operand2);
void WriteFUnordGreaterThan(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2);
void WriteFOrdLessThanEqual(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2);
void WriteFUnordLessThanEqual(Blob *blob,
                              IdResultType idResultType,
                              IdResult idResult,
                              IdRef operand1,
                              IdRef operand2);
void WriteFOrdGreaterThanEqual(Blob *blob,
                               IdResultType idResultType,
                               IdResult idResult,
                               IdRef operand1,
                               IdRef operand2);
void WriteFUnordGreaterThanEqual(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdRef operand1,
                                 IdRef operand2);
void WriteShiftRightLogical(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef base,
                            IdRef shift);
void WriteShiftRightArithmetic(Blob *blob,
                               IdResultType idResultType,
                               IdResult idResult,
                               IdRef base,
                               IdRef shift);
void WriteShiftLeftLogical(Blob *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef base,
                           IdRef shift);
void WriteBitwiseOr(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2);
void WriteBitwiseXor(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2);
void WriteBitwiseAnd(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2);
void WriteNot(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef operand);
void WriteBitFieldInsert(Blob *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef base,
                         IdRef insert,
                         IdRef offset,
                         IdRef count);
void WriteBitFieldSExtract(Blob *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef base,
                           IdRef offset,
                           IdRef count);
void WriteBitFieldUExtract(Blob *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef base,
                           IdRef offset,
                           IdRef count);
void WriteBitReverse(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef base);
void WriteBitCount(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef base);
void WriteDPdx(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteDPdy(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteFwidth(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteDPdxFine(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteDPdyFine(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteFwidthFine(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteDPdxCoarse(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteDPdyCoarse(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteFwidthCoarse(Blob *blob, IdResultType idResultType, IdResult idResult, IdRef p);
void WriteEmitVertex(Blob *blob);
void WriteEndPrimitive(Blob *blob);
void WriteEmitStreamVertex(Blob *blob, IdRef stream);
void WriteEndStreamPrimitive(Blob *blob, IdRef stream);
void WriteControlBarrier(Blob *blob,
                         IdScope execution,
                         IdScope memory,
                         IdMemorySemantics semantics);
void WriteMemoryBarrier(Blob *blob, IdScope memory, IdMemorySemantics semantics);
void WriteAtomicLoad(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics);
void WriteAtomicStore(Blob *blob,
                      IdRef pointer,
                      IdScope scope,
                      IdMemorySemantics semantics,
                      IdRef value);
void WriteAtomicExchange(Blob *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef pointer,
                         IdScope scope,
                         IdMemorySemantics semantics,
                         IdRef value);
void WriteAtomicCompareExchange(Blob *blob,
                                IdResultType idResultType,
                                IdResult idResult,
                                IdRef pointer,
                                IdScope scope,
                                IdMemorySemantics equal,
                                IdMemorySemantics unequal,
                                IdRef value,
                                IdRef comparator);
void WriteAtomicIIncrement(Blob *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef pointer,
                           IdScope scope,
                           IdMemorySemantics semantics);
void WriteAtomicIDecrement(Blob *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef pointer,
                           IdScope scope,
                           IdMemorySemantics semantics);
void WriteAtomicIAdd(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicISub(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicSMin(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicUMin(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicSMax(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicUMax(Blob *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicAnd(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef pointer,
                    IdScope scope,
                    IdMemorySemantics semantics,
                    IdRef value);
void WriteAtomicOr(Blob *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef pointer,
                   IdScope scope,
                   IdMemorySemantics semantics,
                   IdRef value);
void WriteAtomicXor(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef pointer,
                    IdScope scope,
                    IdMemorySemantics semantics,
                    IdRef value);
void WritePhi(Blob *blob,
              IdResultType idResultType,
              IdResult idResult,
              const PairIdRefIdRefList &variableParentPairList);
void WriteLoopMerge(Blob *blob,
                    IdRef mergeBlock,
                    IdRef continueTarget,
                    spv::LoopControlMask loopControl);
void WriteSelectionMerge(Blob *blob, IdRef mergeBlock, spv::SelectionControlMask selectionControl);
void WriteLabel(Blob *blob, IdResult idResult);
void WriteBranch(Blob *blob, IdRef targetLabel);
void WriteBranchConditional(Blob *blob,
                            IdRef condition,
                            IdRef trueLabel,
                            IdRef falseLabel,
                            const LiteralIntegerList &branchweightsList);
void WriteSwitch(Blob *blob,
                 IdRef selector,
                 IdRef default_,
                 const PairLiteralIntegerIdRefList &targetPairList);
void WriteKill(Blob *blob);
void WriteReturn(Blob *blob);
void WriteReturnValue(Blob *blob, IdRef value);
void WriteUnreachable(Blob *blob);
void WriteGroupAll(Blob *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdScope execution,
                   IdRef predicate);
void WriteGroupAny(Blob *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdScope execution,
                   IdRef predicate);
void WriteGroupBroadcast(Blob *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdScope execution,
                         IdRef value,
                         IdRef localId);
void WriteGroupIAdd(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteGroupFAdd(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteGroupFMin(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteGroupUMin(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteGroupSMin(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteGroupFMax(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteGroupUMax(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteGroupSMax(Blob *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x);
void WriteImageSparseSampleImplicitLod(Blob *blob,
                                       IdResultType idResultType,
                                       IdResult idResult,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       const spv::ImageOperandsMask *imageOperands,
                                       const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleExplicitLod(Blob *blob,
                                       IdResultType idResultType,
                                       IdResult idResult,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       spv::ImageOperandsMask imageOperands,
                                       const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleDrefImplicitLod(Blob *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           const spv::ImageOperandsMask *imageOperands,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleDrefExplicitLod(Blob *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           spv::ImageOperandsMask imageOperands,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjImplicitLod(Blob *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           const spv::ImageOperandsMask *imageOperands,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjExplicitLod(Blob *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           spv::ImageOperandsMask imageOperands,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjDrefImplicitLod(Blob *blob,
                                               IdResultType idResultType,
                                               IdResult idResult,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               const spv::ImageOperandsMask *imageOperands,
                                               const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjDrefExplicitLod(Blob *blob,
                                               IdResultType idResultType,
                                               IdResult idResult,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               spv::ImageOperandsMask imageOperands,
                                               const IdRefList &imageOperandIdsList);
void WriteImageSparseFetch(Blob *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef image,
                           IdRef coordinate,
                           const spv::ImageOperandsMask *imageOperands,
                           const IdRefList &imageOperandIdsList);
void WriteImageSparseGather(Blob *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef sampledImage,
                            IdRef coordinate,
                            IdRef component,
                            const spv::ImageOperandsMask *imageOperands,
                            const IdRefList &imageOperandIdsList);
void WriteImageSparseDrefGather(Blob *blob,
                                IdResultType idResultType,
                                IdResult idResult,
                                IdRef sampledImage,
                                IdRef coordinate,
                                IdRef dref,
                                const spv::ImageOperandsMask *imageOperands,
                                const IdRefList &imageOperandIdsList);
void WriteImageSparseTexelsResident(Blob *blob,
                                    IdResultType idResultType,
                                    IdResult idResult,
                                    IdRef residentCode);
void WriteNoLine(Blob *blob);
void WriteImageSparseRead(Blob *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef image,
                          IdRef coordinate,
                          const spv::ImageOperandsMask *imageOperands,
                          const IdRefList &imageOperandIdsList);
void WriteGroupIAddNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);
void WriteGroupFAddNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);
void WriteGroupFMinNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);
void WriteGroupUMinNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);
void WriteGroupSMinNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);
void WriteGroupFMaxNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);
void WriteGroupUMaxNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);
void WriteGroupSMaxNonUniformAMD(Blob *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x);

}  // namespace spirv
}  // namespace angle

#endif  // COMMON_SPIRV_SPIRVINSTRUCTIONBUILDERAUTOGEN_H_
