/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import spec.jbb.JBButil;

public class GraphImage
extends BufferedImage {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Licensed Materials - Property of SPEC";
    private double prevx;
    private double prevy;
    private boolean prevSet;
    private double alphax;
    private double alphay;
    private int pixelsize;
    private int pixeltype;
    private Color pixelcolor;
    private Graphics graphics;
    private float quality;
    private boolean connectPointsEnabled;
    public static final int MINX = 0;
    public static final int MAXX = 1;
    public static final int MINY = 2;
    public static final int MAXY = 3;
    public static final int DASH_LENGTH = 10;
    public static final int AXIS_TICK_RADIUS = 4;
    public static final int DEFAULT_WIDTH = 250;
    public static final int DEFAULT_HEIGHT = 250;
    public static final int PIXEL_TYPE_CIRCLE = 0;
    public static final int PIXEL_TYPE_SQUARE = 1;
    public static final int DEFAULT_PIXEL_SIZE = 1;
    public static final int DEFAULT_PIXEL_TYPE = 0;
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.red;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.black;
    public static final String DEFAULT_FILENAME = "GraphImage.jpg";
    public static final float DEFAULT_JPEG_QUALITY = 1.0f;
    public static final Font FONT = new Font("Monospaced", 0, 10);
    public static final double[] DEFAULT_SCALE = new double[]{-5.0, 5.0, -5.0, 5.0};
    private final double[] scale = new double[DEFAULT_SCALE.length];
    private final DecimalFormat dfx = new DecimalFormat("#.##");
    private final DecimalFormat dfy = new DecimalFormat("#.##");

    public GraphImage() {
        this(250, 250);
    }

    public GraphImage(int n, int n2) {
        super(n, n2, 5);
        this.init();
    }

    private void init() {
        this.graphics = this.getGraphics();
        this.graphics.setFont(FONT);
        this.setScale(DEFAULT_SCALE);
        this.setPixelSize(1);
        this.setPixelType(0);
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.setForeground(DEFAULT_FOREGROUND_COLOR);
        this.setImageQuality(1.0f);
        this.setConnectPointsEnabled(false);
        this.setXYAxesLabelsPrecision(2, 2);
    }

    public void setImageQuality(float f) {
        if (f < 0.0f || f > 1.0f) {
            return;
        }
        this.quality = f;
    }

    public void setPixelSize(int n) {
        this.pixelsize = n;
    }

    public void setPixelType(int n) {
        this.pixeltype = n;
    }

    public void setBackground(Color color) {
        this.graphics.setColor(color);
        this.graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void setForeground(Color color) {
        this.pixelcolor = color;
    }

    public int getSuggestedYAxisTickInterval(int n, double d) {
        double d2;
        int n2;
        double d3 = d / (double)n;
        int n3 = (int)(Math.log(d3) / Math.log(10.0));
        int n4 = n3 + 1;
        int[] nArray = new int[10];
        nArray[0] = (int)Math.pow(10.0, n3);
        nArray[9] = (int)Math.pow(10.0, n4);
        for (n2 = 0; n2 < nArray.length - 1; ++n2) {
            nArray[n2 + 1] = nArray[n2] + nArray[0];
        }
        n2 = 9;
        int n5 = Integer.MAX_VALUE;
        for (int i = nArray.length - 1; i >= 0 && !((d2 = (double)nArray[i] - d3) < 0.0); --i) {
            int n6 = (int)d2;
            if (n6 > n5 && n5 >= 0) continue;
            n5 = n6;
            n2 = i;
        }
        return nArray[n2];
    }

    public synchronized double getSuggestedMinXScale(double d, double d2) {
        double[] dArray = new double[this.scale.length];
        System.arraycopy(this.scale, 0, dArray, 0, dArray.length);
        this.setScale(new double[]{0.0, d, 0.0, d2});
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.dfy.format(d2)) + 4 + 20;
        double d3 = -(this.scale[0] + (double)n * this.alphax);
        this.setScale(dArray);
        return d3;
    }

    public synchronized double getSuggestedMinYScale(double d, double d2) {
        double[] dArray = new double[this.scale.length];
        System.arraycopy(this.scale, 0, dArray, 0, dArray.length);
        this.setScale(new double[]{0.0, d, 0.0, d2});
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        int n = 4 + fontMetrics.getHeight() + 40;
        double d3 = this.scale[3] - (double)n * this.alphay - this.scale[3];
        this.setScale(dArray);
        return d3;
    }

    public void setScale(double[] dArray) {
        if (dArray == null || dArray.length < this.scale.length) {
            return;
        }
        System.arraycopy(dArray, 0, this.scale, 0, this.scale.length);
        this.alphax = (this.scale[1] - this.scale[0]) / (double)this.getWidth();
        this.alphay = (this.scale[3] - this.scale[2]) / (double)this.getHeight();
    }

    private int getLinearMapX(double d) {
        return (int)Math.round((d - this.scale[0]) / this.alphax);
    }

    private int getLinearMapY(double d) {
        return (int)Math.round((this.scale[3] - d) / this.alphay);
    }

    private void setAxisLabelsPrecision(DecimalFormat decimalFormat, int n, int n2) {
        decimalFormat.setMinimumIntegerDigits(n);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setMaximumFractionDigits(n2);
    }

    public void setXAxisLabelsPrecision(int n, int n2) {
        this.setAxisLabelsPrecision(this.dfx, n, n2);
    }

    public void setYAxisLabelsPrecision(int n, int n2) {
        this.setAxisLabelsPrecision(this.dfy, n, n2);
    }

    public void setXYAxesLabelsPrecision(int n, int n2) {
        this.setAxisLabelsPrecision(this.dfx, 1, n);
        this.setAxisLabelsPrecision(this.dfy, 1, n2);
    }

    public void plotXYAxes(Color color) {
        this.graphics.setColor(color);
        int n = this.getLinearMapX(0.0);
        int n2 = this.getLinearMapY(0.0);
        this.graphics.drawLine(0, n2, this.getWidth(), n2);
        this.graphics.drawLine(n, 0, n, this.getHeight());
    }

    public void plotXAxisTicks(double d, Color color, String string) {
        int n;
        double d2;
        this.graphics.setColor(color);
        int n2 = this.getLinearMapY(0.0);
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        for (d2 = 0.0; d2 <= this.scale[1]; d2 += d) {
            n = this.getLinearMapX(d2);
            this.graphics.drawLine(n, n2 - 4 * (d2 == 0.0 ? 2 : 1), n, n2 + 4 * (d2 == 0.0 ? 2 : 1));
            if (d2 == 0.0) continue;
            String string2 = this.dfx.format(d2);
            int n3 = fontMetrics.stringWidth(string2) / 2;
            this.graphics.drawString(string2, n - n3, n2 + 4 + fontMetrics.getAscent());
        }
        for (d2 = 0.0; d2 >= this.scale[0]; d2 -= d) {
            n = this.getLinearMapX(d2);
            this.graphics.drawLine(n, n2 - 4, n, n2 + 4);
        }
        this.graphics.drawString(string, this.getLinearMapX(this.scale[1] - 2.0), n2 + 12 + fontMetrics.getAscent());
    }

    public void plotYAxisTicks(double d, Color color, String string) {
        int n;
        double d2;
        this.graphics.setColor(color);
        int n2 = this.getLinearMapX(0.0);
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        for (d2 = 0.0; d2 <= this.scale[3] - d; d2 += d) {
            n = this.getLinearMapY(d2);
            this.graphics.drawLine(n2 - 4 * (d2 == 0.0 ? 2 : 1), n, n2 + 4 * (d2 == 0.0 ? 2 : 1), n);
            if (d2 == 0.0) continue;
            String string2 = this.dfy.format(d2);
            this.graphics.drawString(string2, n2 - 4 - fontMetrics.stringWidth(string2) - 2, n + fontMetrics.getDescent());
        }
        for (d2 = 0.0; d2 >= this.scale[2]; d2 -= d) {
            n = this.getLinearMapY(d2);
            this.graphics.drawLine(n2 - 4, n, n2 + 4, n);
        }
        this.graphics.drawString(string, n2 - 4 - fontMetrics.stringWidth(string), this.getLinearMapY(this.scale[3]) + 4 + fontMetrics.getDescent());
    }

    public void drawLegend(String string, double d, double d2, Color color, Color color2, String string2) {
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        int n = this.getLinearMapX(this.scale[0] + d);
        int n2 = this.getLinearMapY(0.0) + (int)(d2 * 4.0) + fontMetrics.getAscent();
        int n3 = this.pixelsize;
        int n4 = (int)Math.round((double)n3 / 2.0);
        this.graphics.setColor(color);
        if (string2.equals("Line")) {
            this.graphics.drawLine(n, n2 - fontMetrics.getAscent() / 2, n + 20, n2 - fontMetrics.getAscent() / 2);
            this.graphics.setColor(color2);
            this.graphics.drawString(" - " + string, n + 22, n2);
        } else if (string2.equals("Dot")) {
            this.graphics.fillArc(n - n4, n2 - n4 - fontMetrics.getAscent() / 2, n3, n3, 0, 360);
            this.graphics.setColor(color2);
            this.graphics.drawString(" - " + string, n, n2);
        }
    }

    public void setConnectPointsEnabled(boolean bl) {
        this.connectPointsEnabled = bl;
    }

    public void resetConnectPoints() {
        this.prevSet = false;
    }

    public void plotLine(double d, double d2, double d3, double d4) {
        this.graphics.setColor(this.pixelcolor);
        this.graphics.drawLine(this.getLinearMapX(d), this.getLinearMapY(d2), this.getLinearMapX(d3), this.getLinearMapY(d4));
    }

    public void plotFlatLine(double d, double d2, double d3, Color color) {
        int n = this.getLinearMapY(d3);
        int n2 = this.getLinearMapX(d);
        int n3 = this.getLinearMapX(d2);
        this.graphics.setColor(color);
        for (int i = n2; i < n3; i += 20) {
            this.graphics.drawLine(i, n, i + 10, n);
        }
    }

    public void plotFlatLine(double d, Color color) {
        int n = this.getWidth();
        int n2 = this.getLinearMapY(d);
        int n3 = this.getLinearMapX(0.0);
        this.graphics.setColor(color);
        for (int i = n3; i < n; i += 20) {
            this.graphics.drawLine(i, n2, i + 10, n2);
        }
    }

    public void plot(double d, double d2, int n, Color color) {
        if (this.connectPointsEnabled) {
            if (this.prevSet) {
                this.plotLine(this.prevx, this.prevy, d, d2);
            }
            this.prevSet = true;
            this.prevx = d;
            this.prevy = d2;
        } else {
            this.prevSet = false;
        }
        this.graphics.setColor(color);
        int n2 = this.getLinearMapX(d);
        int n3 = this.getLinearMapY(d2);
        int n4 = (int)Math.round((double)n / 2.0);
        switch (this.pixeltype) {
            case 0: {
                this.graphics.fillArc(n2 - n4, n3 - n4, n, n, 0, 360);
                break;
            }
            case 1: {
                this.graphics.fillRect(n2 - n4, n3 - n4, n, n);
            }
        }
    }

    public void plot(double d, double d2, Color color) {
        this.plot(d, d2, this.pixelsize, color);
    }

    public void plot(double d, double d2) {
        this.plot(d, d2, this.pixelsize, this.pixelcolor);
    }

    public void make() {
        this.make(DEFAULT_FILENAME);
    }

    public void make(String string) {
        if (string == null) {
            return;
        }
        try {
            File file = new File(string);
            ImageIO.write((RenderedImage)this, "jpeg", file);
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Exception: " + exception.getMessage(), exception);
        }
    }
}

