// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Webcam.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.webcam {

  public class Information : ICloneable {
    public object Clone() {
      Information copy = new Information();
      copy.id = this.id;
      copy.supportedFormats = this.supportedFormats;
      copy.device = this.device;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["id"] = this.id;
      json["supportedFormats"] = new JsonArray(this.supportedFormats.Select(
        _value => (JsonValue)(_value.Encode())));
      json["device"] = this.device;
      return json;
    }

    public static Information Decode(LightJson.JsonObject json, Agent agent) {
      Information inst = new Information();
      inst.id = (string)json["id"];
      inst.supportedFormats = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.Format>(json["supportedFormats"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.webcam.Format.Decode(_value, agent)));
      inst.device = (string)json["device"];
      return inst;
    }

    public string id = "";
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.webcam.Format> supportedFormats = new System.Collections.Generic.List<Com.Raritan.Idl.webcam.Format>();
    public string device = "";
  }
}
