% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd-examples.R
\name{escape_examples}
\alias{escape_examples}
\title{Escape examples}
\usage{
escape_examples(x)
}
\description{
This documentation topic is used primarily for testing and to record
our understanding of the \verb{\\example\{\}} escaping rules.
See \url{https://developer.r-project.org/parseRd.pdf} for the details provided
by R core.
}
\examples{
# In examples we automatically escape Rd comments (\%):
100 \%\% 30
# even if they are in strings
"50\%"

# and \\ and \v inside of strings and symbols
"\\v" # vertical tab
"\\\\"
# but not comments: \l \v

# other string escapes are left as is
"\""
"\n"

# Otherwise, backslashes and parentheses are left as is. This
# means that you need to escape unbalanced parentheses, which typically only
# occur in \dontshow{}:
\dontshow{if (FALSE) \{ }
print("Hello")
\dontshow{ \} }

# You also need to escape backslashes in infix operators and comments
# (this is generally rare)
`\%\\\\\%` <- function(x, y) x + y
10 \%\\\% 20
# \\\\ (renders as two backslashes)
}
\keyword{internal}
