% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle.R
\name{intrle}
\alias{intrle}
\alias{intisasc}
\alias{intisdesc}
\title{Hybrid Index, C-coded utilities}
\usage{
intrle(x)

intisasc(x, na.method = c("none", "break", "skip")[2])

intisdesc(x, na.method = c("none", "break", "skip")[1])
}
\arguments{
\item{x}{an integer vector}

\item{na.method}{one of "none","break","skip", see details. The strange defaults stem from the initial usage.}
}
\value{
\code{intrle} returns an object of class \code{\link{rle}} or NULL,
if rle-compression is not efficient (compression factor <3 or length(x)<3).
\cr \code{intisasc} returns one of \code{FALSE, NA, TRUE} \cr
\code{intisdesc} returns one of \code{FALSE, TRUE} (if the input contains
NAs, the output is undefined)
}
\description{
These C-coded utilitites speed up index preprocessing considerably.
}
\details{
\code{intrle} is by factor 50 faster and needs less RAM (2x its input
vector) compared to \code{\link{rle}} which needs 9x the RAM of its input
vector.  This is achieved because we allow the C-code of \code{intrle} to
break when it turns out, that rle-packing will not achieve a compression
factor of 3 or better.  \cr \code{intisasc} is a faster version of
\code{\link{is.unsorted}}: it checks whether \code{x} is sorted.\cr 
\code{intisdesc} checks for being sorted descending and 
by default default assumes that the input \code{x} contains no NAs. 
\code{na.method="none"} treats \code{NAs} (the smallest integer) like every other integer and hence returns either \code{TRUE} or \code{FALSE}
\code{na.method="break"} checks for \code{NAs} and returns either \code{NA} as soon as  \code{NA} is encountered. 
\code{na.method="skip"} checks for \code{NAs} and skips over them, hence decides the return value only on the basis of non-NA values.
}
\section{Functions}{
\itemize{
\item \code{intisasc}: check whether integer vector is ascending

\item \code{intisdesc}: check whether integer vector is descending
}}

\examples{

  intrle(sample(1:10))
  intrle(diff(1:10))
  intisasc(1:10)
  intisasc(10:1)
  intisasc(c(NA, 1:10))
  intisdesc(1:10)
  intisdesc(c(10:1, NA))
  intisdesc(c(10:6, NA, 5:1))
  intisdesc(c(10:6, NA, 5:1), na.method="skip")
  intisdesc(c(10:6, NA, 5:1), na.method="break")

}
\seealso{
\code{\link[ff]{hi}}, \code{\link{rle}}, \code{\link{is.unsorted}},
\code{\link[ff]{is.sorted}}
}
\author{
Jens Oehlschlägel
}
\keyword{IO}
\keyword{data}
