# Contributing

From opening a bug report to creating a pull request: every contribution is
appreciated and welcome. If you're planning to implement a new feature or change
the api please create an issue first. This way we can ensure that your precious
work is not in vain.

## Issues

Most of the time, if webpack is not working correctly for you it is a simple configuration issue.

If you are having difficulty, please search the [StackOverflow with the webpack tag](http://stackoverflow.com/tags/webpack) for questions related
to the `html-loader`. If you can find an answer to your issue, please post a question in [StackOverflow](http://stackoverflow.com/tags/webpack) or
the [webpack Gitter](https://gitter.im/webpack/webpack) and include both your webpack & html-loader versions.

**If you have discovered a bug or have a feature suggestion, feel free to create an issue on Github.**

## Setup

```bash
git clone https://github.com/webpack/html-loader.git
cd html-loader
npm install
```

To run the entire test suite use:

```bash
npm test
```

## Submitting Changes

After getting some feedback, push to your fork and submit a pull request. We
may suggest some changes or improvements or alternatives, but for small changes
your pull request should be accepted quickly.

Some things that will increase the chance that your pull request is accepted:

- Write tests
- Follow the existing Webpack coding style defined in the eslint jsbeutify and editor config rules.
- Write a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html)
