// GPars - Groovy Parallel Systems
//
// Copyright © 2008-11  The original author or authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package groovyx.gpars.samples.forkjoin

import jsr166y.ForkJoinPool
import jsr166y.ForkJoinTask
import jsr166y.RecursiveTask

class Fibonacci extends RecursiveTask<Integer> {
    final int n;

    Fibonacci(int n) { this.n = n; }

    Integer compute() {
        if (n <= 1)
            return n;
        Fibonacci f1 = new Fibonacci(n - 1);
        Fibonacci f2 = new Fibonacci(n - 2);
        f1.fork();
        f2.fork()
        return f2.join() + f1.join();  //The order matters here
    }
}

final ForkJoinPool pool = new ForkJoinPool(3)
final ForkJoinTask<java.lang.Integer> result = pool.submit(new Fibonacci(10))
println result.get()
