/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.ModelClass;

public class Callable {
    public static final int DYNAMIC = 1;
    public static final int CAN_BE_INVALIDATED = 2;
    public static final int STATIC = 4;
    public final Type type;
    public final String name;
    public final ModelClass resolvedType;
    private final int mFlags;

    public Callable(Type type, String name, ModelClass resolvedType, int flags) {
        this.type = type;
        this.name = name;
        this.resolvedType = resolvedType;
        this.mFlags = flags;
    }

    public String getTypeCodeName() {
        return this.resolvedType.toJavaCode();
    }

    public boolean isDynamic() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isStatic() {
        return (this.mFlags & 4) != 0;
    }

    public boolean canBeInvalidated() {
        return (this.mFlags & 2) != 0;
    }

    public String toString() {
        return "Callable{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", resolvedType=" + this.resolvedType + ", isDynamic=" + this.isDynamic() + ", canBeInvalidated=" + this.canBeInvalidated() + ", static=" + this.isStatic() + '}';
    }

    public static enum Type {
        METHOD,
        FIELD;

    }
}

