// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "time"

// MobileApp An abstract class containing the base properties for Intune mobile apps.
type MobileApp struct {
	// Entity is the base model of MobileApp
	Entity
	// DisplayName The admin provided or imported title of the app.
	DisplayName *string `json:"displayName,omitempty"`
	// Description The description of the app.
	Description *string `json:"description,omitempty"`
	// Publisher The publisher of the app.
	Publisher *string `json:"publisher,omitempty"`
	// LargeIcon The large icon, to be displayed in the app details and used for upload of the icon.
	LargeIcon *MimeContent `json:"largeIcon,omitempty"`
	// CreatedDateTime The date and time the app was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// LastModifiedDateTime The date and time the app was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// IsFeatured The value indicating whether the app is marked as featured by the admin.
	IsFeatured *bool `json:"isFeatured,omitempty"`
	// PrivacyInformationURL The privacy statement Url.
	PrivacyInformationURL *string `json:"privacyInformationUrl,omitempty"`
	// InformationURL The more information Url.
	InformationURL *string `json:"informationUrl,omitempty"`
	// Owner The owner of the app.
	Owner *string `json:"owner,omitempty"`
	// Developer The developer of the app.
	Developer *string `json:"developer,omitempty"`
	// Notes Notes for the app.
	Notes *string `json:"notes,omitempty"`
	// UploadState The upload state.
	UploadState *int `json:"uploadState,omitempty"`
	// PublishingState The publishing state for the app. The app cannot be assigned unless the app is published.
	PublishingState *MobileAppPublishingState `json:"publishingState,omitempty"`
	// IsAssigned The value indicating whether the app is assigned to at least one group.
	IsAssigned *bool `json:"isAssigned,omitempty"`
	// RoleScopeTagIDs List of scope tag ids for this mobile app.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// DependentAppCount The total number of dependencies the child app has.
	DependentAppCount *int `json:"dependentAppCount,omitempty"`
	// Categories undocumented
	Categories []MobileAppCategory `json:"categories,omitempty"`
	// Assignments undocumented
	Assignments []MobileAppAssignment `json:"assignments,omitempty"`
	// InstallSummary undocumented
	InstallSummary *MobileAppInstallSummary `json:"installSummary,omitempty"`
	// DeviceStatuses undocumented
	DeviceStatuses []MobileAppInstallStatus `json:"deviceStatuses,omitempty"`
	// UserStatuses undocumented
	UserStatuses []UserAppInstallStatus `json:"userStatuses,omitempty"`
	// Relationships undocumented
	Relationships []MobileAppRelationship `json:"relationships,omitempty"`
}

// MobileAppAssignment A class containing the properties used for Group Assignment of a Mobile App.
type MobileAppAssignment struct {
	// Entity is the base model of MobileAppAssignment
	Entity
	// Intent The install intent defined by the admin.
	Intent *InstallIntent `json:"intent,omitempty"`
	// Target The target group assignment defined by the admin.
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
	// Settings The settings for target assignment defined by the admin.
	Settings *MobileAppAssignmentSettings `json:"settings,omitempty"`
	// Source The resource type which is the source for the assignment.
	Source *DeviceAndAppManagementAssignmentSource `json:"source,omitempty"`
	// SourceID The identifier of the source of the assignment.
	SourceID *string `json:"sourceId,omitempty"`
}

// MobileAppAssignmentSettings undocumented
type MobileAppAssignmentSettings struct {
	// Object is the base model of MobileAppAssignmentSettings
	Object
}

// MobileAppCategory Contains properties for a single Intune app category.
type MobileAppCategory struct {
	// Entity is the base model of MobileAppCategory
	Entity
	// DisplayName The name of the app category.
	DisplayName *string `json:"displayName,omitempty"`
	// LastModifiedDateTime The date and time the mobileAppCategory was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
}

// MobileAppContent Contains content properties for a specific app version. Each mobileAppContent can have multiple mobileAppContentFile.
type MobileAppContent struct {
	// Entity is the base model of MobileAppContent
	Entity
	// Files undocumented
	Files []MobileAppContentFile `json:"files,omitempty"`
	// ContainedApps undocumented
	ContainedApps []MobileContainedApp `json:"containedApps,omitempty"`
}

// MobileAppContentFile Contains properties for a single installer file that is associated with a given mobileAppContent version.
type MobileAppContentFile struct {
	// Entity is the base model of MobileAppContentFile
	Entity
	// AzureStorageURI The Azure Storage URI.
	AzureStorageURI *string `json:"azureStorageUri,omitempty"`
	// IsCommitted A value indicating whether the file is committed.
	IsCommitted *bool `json:"isCommitted,omitempty"`
	// CreatedDateTime The time the file was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// Name the file name.
	Name *string `json:"name,omitempty"`
	// Size The size of the file prior to encryption.
	Size *int `json:"size,omitempty"`
	// SizeEncrypted The size of the file after encryption.
	SizeEncrypted *int `json:"sizeEncrypted,omitempty"`
	// AzureStorageURIExpirationDateTime The time the Azure storage Uri expires.
	AzureStorageURIExpirationDateTime *time.Time `json:"azureStorageUriExpirationDateTime,omitempty"`
	// Manifest The manifest information.
	Manifest *Binary `json:"manifest,omitempty"`
	// UploadState The state of the current upload request.
	UploadState *MobileAppContentFileUploadState `json:"uploadState,omitempty"`
	// IsFrameworkFile A value indicating whether the file is a framework file.
	IsFrameworkFile *bool `json:"isFrameworkFile,omitempty"`
	// IsDependency Whether the content file is a dependency for the main content file.
	IsDependency *bool `json:"isDependency,omitempty"`
}

// MobileAppDependency Describes a dependency type between two mobile apps.
type MobileAppDependency struct {
	// MobileAppRelationship is the base model of MobileAppDependency
	MobileAppRelationship
	// DependencyType The type of dependency relationship between the parent and child apps.
	DependencyType *MobileAppDependencyType `json:"dependencyType,omitempty"`
	// DependentAppCount The total number of dependencies the child app has.
	DependentAppCount *int `json:"dependentAppCount,omitempty"`
}

// MobileAppIdentifier undocumented
type MobileAppIdentifier struct {
	// Object is the base model of MobileAppIdentifier
	Object
}

// MobileAppInstallStatus Contains properties for the installation state of a mobile app for a device.
type MobileAppInstallStatus struct {
	// Entity is the base model of MobileAppInstallStatus
	Entity
	// DeviceName Device name
	DeviceName *string `json:"deviceName,omitempty"`
	// DeviceID Device ID
	DeviceID *string `json:"deviceId,omitempty"`
	// LastSyncDateTime Last sync date time
	LastSyncDateTime *time.Time `json:"lastSyncDateTime,omitempty"`
	// MobileAppInstallStatusValue The install state of the app.
	MobileAppInstallStatusValue *ResultantAppState `json:"mobileAppInstallStatusValue,omitempty"`
	// InstallState The install state of the app.
	InstallState *ResultantAppState `json:"installState,omitempty"`
	// InstallStateDetail The install state detail of the app.
	InstallStateDetail *ResultantAppStateDetail `json:"installStateDetail,omitempty"`
	// ErrorCode The error code for install or uninstall failures.
	ErrorCode *int `json:"errorCode,omitempty"`
	// OsVersion OS Version
	OsVersion *string `json:"osVersion,omitempty"`
	// OsDescription OS Description
	OsDescription *string `json:"osDescription,omitempty"`
	// UserName Device User Name
	UserName *string `json:"userName,omitempty"`
	// UserPrincipalName User Principal Name
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// DisplayVersion Human readable version of the application
	DisplayVersion *string `json:"displayVersion,omitempty"`
	// App undocumented
	App *MobileApp `json:"app,omitempty"`
}

// MobileAppInstallSummary Contains properties for the installation summary of a mobile app.
type MobileAppInstallSummary struct {
	// Entity is the base model of MobileAppInstallSummary
	Entity
	// InstalledDeviceCount Number of Devices that have successfully installed this app.
	InstalledDeviceCount *int `json:"installedDeviceCount,omitempty"`
	// FailedDeviceCount Number of Devices that have failed to install this app.
	FailedDeviceCount *int `json:"failedDeviceCount,omitempty"`
	// NotApplicableDeviceCount Number of Devices that are not applicable for this app.
	NotApplicableDeviceCount *int `json:"notApplicableDeviceCount,omitempty"`
	// NotInstalledDeviceCount Number of Devices that does not have this app installed.
	NotInstalledDeviceCount *int `json:"notInstalledDeviceCount,omitempty"`
	// PendingInstallDeviceCount Number of Devices that have been notified to install this app.
	PendingInstallDeviceCount *int `json:"pendingInstallDeviceCount,omitempty"`
	// InstalledUserCount Number of Users whose devices have all succeeded to install this app.
	InstalledUserCount *int `json:"installedUserCount,omitempty"`
	// FailedUserCount Number of Users that have 1 or more device that failed to install this app.
	FailedUserCount *int `json:"failedUserCount,omitempty"`
	// NotApplicableUserCount Number of Users whose devices were all not applicable for this app.
	NotApplicableUserCount *int `json:"notApplicableUserCount,omitempty"`
	// NotInstalledUserCount Number of Users that have 1 or more devices that did not install this app.
	NotInstalledUserCount *int `json:"notInstalledUserCount,omitempty"`
	// PendingInstallUserCount Number of Users that have 1 or more device that have been notified to install this app and have 0 devices with failures.
	PendingInstallUserCount *int `json:"pendingInstallUserCount,omitempty"`
}

// MobileAppInstallTimeSettings undocumented
type MobileAppInstallTimeSettings struct {
	// Object is the base model of MobileAppInstallTimeSettings
	Object
	// UseLocalTime Whether the local device time or UTC time should be used when determining the available and deadline times.
	UseLocalTime *bool `json:"useLocalTime,omitempty"`
	// StartDateTime The time at which the app should be available for installation.
	StartDateTime *time.Time `json:"startDateTime,omitempty"`
	// DeadlineDateTime The time at which the app should be installed.
	DeadlineDateTime *time.Time `json:"deadlineDateTime,omitempty"`
}

// MobileAppIntentAndState MobileApp Intent and Install State for a given device.
type MobileAppIntentAndState struct {
	// Entity is the base model of MobileAppIntentAndState
	Entity
	// ManagedDeviceIdentifier Device identifier created or collected by Intune.
	ManagedDeviceIdentifier *string `json:"managedDeviceIdentifier,omitempty"`
	// UserID Identifier for the user that tried to enroll the device.
	UserID *string `json:"userId,omitempty"`
	// MobileAppList The list of payload intents and states for the tenant.
	MobileAppList []MobileAppIntentAndStateDetail `json:"mobileAppList,omitempty"`
}

// MobileAppIntentAndStateDetail undocumented
type MobileAppIntentAndStateDetail struct {
	// Object is the base model of MobileAppIntentAndStateDetail
	Object
	// ApplicationID MobieApp identifier.
	ApplicationID *string `json:"applicationId,omitempty"`
	// DisplayName The admin provided or imported title of the app.
	DisplayName *string `json:"displayName,omitempty"`
	// MobileAppIntent Mobile App Intent.
	MobileAppIntent *MobileAppIntent `json:"mobileAppIntent,omitempty"`
	// DisplayVersion Human readable version of the application
	DisplayVersion *string `json:"displayVersion,omitempty"`
	// InstallState The install state of the app.
	InstallState *ResultantAppState `json:"installState,omitempty"`
	// SupportedDeviceTypes The supported platforms for the app.
	SupportedDeviceTypes []MobileAppSupportedDeviceType `json:"supportedDeviceTypes,omitempty"`
}

// MobileAppPolicySetItem A class containing the properties used for mobile app PolicySetItem.
type MobileAppPolicySetItem struct {
	// PolicySetItem is the base model of MobileAppPolicySetItem
	PolicySetItem
	// Intent Install intent of the MobileAppPolicySetItem.
	Intent *InstallIntent `json:"intent,omitempty"`
	// Settings Settings of the MobileAppPolicySetItem.
	Settings *MobileAppAssignmentSettings `json:"settings,omitempty"`
}

// MobileAppProvisioningConfigGroupAssignment Contains the properties used to assign an App provisioning configuration to a group.
type MobileAppProvisioningConfigGroupAssignment struct {
	// Entity is the base model of MobileAppProvisioningConfigGroupAssignment
	Entity
	// TargetGroupID The ID of the AAD group in which the app provisioning configuration is being targeted.
	TargetGroupID *string `json:"targetGroupId,omitempty"`
}

// MobileAppRelationship Describes the relationship for a child mobile app to its parent mobile app.
type MobileAppRelationship struct {
	// Entity is the base model of MobileAppRelationship
	Entity
	// TargetID The target child mobile app's app id.
	TargetID *string `json:"targetId,omitempty"`
	// TargetDisplayName The target child mobile app's display name.
	TargetDisplayName *string `json:"targetDisplayName,omitempty"`
}

// MobileAppRelationshipState undocumented
type MobileAppRelationshipState struct {
	// Object is the base model of MobileAppRelationshipState
	Object
	// SourceIDs The collection of source mobile app's ids.
	SourceIDs []string `json:"sourceIds,omitempty"`
	// TargetID The related target app's id.
	TargetID *string `json:"targetId,omitempty"`
	// TargetDisplayName The related target app's display name.
	TargetDisplayName *string `json:"targetDisplayName,omitempty"`
	// DeviceID The corresponding device id.
	DeviceID *string `json:"deviceId,omitempty"`
	// InstallState The install state of the app of target app.
	InstallState *ResultantAppState `json:"installState,omitempty"`
	// InstallStateDetail The install state detail of the app.
	InstallStateDetail *ResultantAppStateDetail `json:"installStateDetail,omitempty"`
	// ErrorCode The error code for install or uninstall failures of target app.
	ErrorCode *int `json:"errorCode,omitempty"`
	// TargetLastSyncDateTime The last sync time of the target app.
	TargetLastSyncDateTime *time.Time `json:"targetLastSyncDateTime,omitempty"`
}

// MobileAppSupportedDeviceType undocumented
type MobileAppSupportedDeviceType struct {
	// Object is the base model of MobileAppSupportedDeviceType
	Object
	// Type Device type
	Type *DeviceType `json:"type,omitempty"`
	// MinimumOperatingSystemVersion Minimum OS version
	MinimumOperatingSystemVersion *string `json:"minimumOperatingSystemVersion,omitempty"`
	// MaximumOperatingSystemVersion Maximum OS version
	MaximumOperatingSystemVersion *string `json:"maximumOperatingSystemVersion,omitempty"`
}

// MobileAppTroubleshootingAppPolicyCreationHistory undocumented
type MobileAppTroubleshootingAppPolicyCreationHistory struct {
	// MobileAppTroubleshootingHistoryItem is the base model of MobileAppTroubleshootingAppPolicyCreationHistory
	MobileAppTroubleshootingHistoryItem
	// RunState Status of the item.
	RunState *RunState `json:"runState,omitempty"`
	// ErrorCode Error code for the failure, empty if no failure.
	ErrorCode *string `json:"errorCode,omitempty"`
}

// MobileAppTroubleshootingAppStateHistory undocumented
type MobileAppTroubleshootingAppStateHistory struct {
	// MobileAppTroubleshootingHistoryItem is the base model of MobileAppTroubleshootingAppStateHistory
	MobileAppTroubleshootingHistoryItem
	// ActionType AAD security group id to which it was targeted.
	ActionType *MobileAppActionType `json:"actionType,omitempty"`
	// RunState Status of the item.
	RunState *RunState `json:"runState,omitempty"`
	// ErrorCode Error code for the failure, empty if no failure.
	ErrorCode *string `json:"errorCode,omitempty"`
}

// MobileAppTroubleshootingAppTargetHistory undocumented
type MobileAppTroubleshootingAppTargetHistory struct {
	// MobileAppTroubleshootingHistoryItem is the base model of MobileAppTroubleshootingAppTargetHistory
	MobileAppTroubleshootingHistoryItem
	// SecurityGroupID AAD security group id to which it was targeted.
	SecurityGroupID *string `json:"securityGroupId,omitempty"`
	// RunState Status of the item.
	RunState *RunState `json:"runState,omitempty"`
	// ErrorCode Error code for the failure, empty if no failure.
	ErrorCode *string `json:"errorCode,omitempty"`
}

// MobileAppTroubleshootingAppUpdateHistory undocumented
type MobileAppTroubleshootingAppUpdateHistory struct {
	// MobileAppTroubleshootingHistoryItem is the base model of MobileAppTroubleshootingAppUpdateHistory
	MobileAppTroubleshootingHistoryItem
}

// MobileAppTroubleshootingDeviceCheckinHistory undocumented
type MobileAppTroubleshootingDeviceCheckinHistory struct {
	// MobileAppTroubleshootingHistoryItem is the base model of MobileAppTroubleshootingDeviceCheckinHistory
	MobileAppTroubleshootingHistoryItem
}

// MobileAppTroubleshootingEvent Event representing a users device application install status.
type MobileAppTroubleshootingEvent struct {
	// DeviceManagementTroubleshootingEvent is the base model of MobileAppTroubleshootingEvent
	DeviceManagementTroubleshootingEvent
	// ManagedDeviceIdentifier Device identifier created or collected by Intune.
	ManagedDeviceIdentifier *string `json:"managedDeviceIdentifier,omitempty"`
	// UserID Identifier for the user that tried to enroll the device.
	UserID *string `json:"userId,omitempty"`
	// ApplicationID Intune application identifier.
	ApplicationID *string `json:"applicationId,omitempty"`
	// History Intune Mobile Application Troubleshooting History Item
	History []MobileAppTroubleshootingHistoryItem `json:"history,omitempty"`
	// AppLogCollectionRequests undocumented
	AppLogCollectionRequests []AppLogCollectionRequestObject `json:"appLogCollectionRequests,omitempty"`
}

// MobileAppTroubleshootingHistoryItem undocumented
type MobileAppTroubleshootingHistoryItem struct {
	// Object is the base model of MobileAppTroubleshootingHistoryItem
	Object
	// OccurrenceDateTime Time when the history item occurred.
	OccurrenceDateTime *time.Time `json:"occurrenceDateTime,omitempty"`
}

// MobileContainedApp An abstract class that represents a contained app in a mobileApp acting as a package.
type MobileContainedApp struct {
	// Entity is the base model of MobileContainedApp
	Entity
}

// MobileLobApp An abstract base class containing properties for all mobile line of business apps.
type MobileLobApp struct {
	// MobileApp is the base model of MobileLobApp
	MobileApp
	// CommittedContentVersion The internal committed content version.
	CommittedContentVersion *string `json:"committedContentVersion,omitempty"`
	// FileName The name of the main Lob application file.
	FileName *string `json:"fileName,omitempty"`
	// Size The total size, including all uploaded files.
	Size *int `json:"size,omitempty"`
	// ContentVersions undocumented
	ContentVersions []MobileAppContent `json:"contentVersions,omitempty"`
}

// MobileThreatDefenseConnector Entity which represents a connection to Mobile threat defense partner.
type MobileThreatDefenseConnector struct {
	// Entity is the base model of MobileThreatDefenseConnector
	Entity
	// LastHeartbeatDateTime DateTime of last Heartbeat recieved from the Data Sync Partner
	LastHeartbeatDateTime *time.Time `json:"lastHeartbeatDateTime,omitempty"`
	// PartnerState Data Sync Partner state for this account
	PartnerState *MobileThreatPartnerTenantState `json:"partnerState,omitempty"`
	// AndroidMobileApplicationManagementEnabled For Android, set whether data from the data sync partner should be used during Mobile Application Management (MAM) evaluations. Only one partner per platform may be enabled for Mobile Application Management (MAM) evaluation.
	AndroidMobileApplicationManagementEnabled *bool `json:"androidMobileApplicationManagementEnabled,omitempty"`
	// IOSMobileApplicationManagementEnabled For IOS, get or set whether data from the data sync partner should be used during Mobile Application Management (MAM) evaluations. Only one partner per platform may be enabled for Mobile Application Management (MAM) evaluation.
	IOSMobileApplicationManagementEnabled *bool `json:"iosMobileApplicationManagementEnabled,omitempty"`
	// AndroidEnabled For Android, set whether data from the data sync partner should be used during compliance evaluations
	AndroidEnabled *bool `json:"androidEnabled,omitempty"`
	// IOSEnabled For IOS, get or set whether data from the data sync partner should be used during compliance evaluations
	IOSEnabled *bool `json:"iosEnabled,omitempty"`
	// WindowsEnabled For Windows, get or set whether data from the data sync partner should be used during compliance evaluations
	WindowsEnabled *bool `json:"windowsEnabled,omitempty"`
	// MacEnabled For Mac, get or set whether data from the data sync partner should be used during compliance evaluations
	MacEnabled *bool `json:"macEnabled,omitempty"`
	// AndroidDeviceBlockedOnMissingPartnerData For Android, set whether Intune must receive data from the data sync partner prior to marking a device compliant
	AndroidDeviceBlockedOnMissingPartnerData *bool `json:"androidDeviceBlockedOnMissingPartnerData,omitempty"`
	// IOSDeviceBlockedOnMissingPartnerData For IOS, set whether Intune must receive data from the data sync partner prior to marking a device compliant
	IOSDeviceBlockedOnMissingPartnerData *bool `json:"iosDeviceBlockedOnMissingPartnerData,omitempty"`
	// WindowsDeviceBlockedOnMissingPartnerData For Windows, set whether Intune must receive data from the data sync partner prior to marking a device compliant
	WindowsDeviceBlockedOnMissingPartnerData *bool `json:"windowsDeviceBlockedOnMissingPartnerData,omitempty"`
	// MacDeviceBlockedOnMissingPartnerData For Mac, get or set whether Intune must receive data from the data sync partner prior to marking a device compliant
	MacDeviceBlockedOnMissingPartnerData *bool `json:"macDeviceBlockedOnMissingPartnerData,omitempty"`
	// PartnerUnsupportedOsVersionBlocked Get or set whether to block devices on the enabled platforms that do not meet the minimum version requirements of the Data Sync Partner
	PartnerUnsupportedOsVersionBlocked *bool `json:"partnerUnsupportedOsVersionBlocked,omitempty"`
	// PartnerUnresponsivenessThresholdInDays Get or Set days the per tenant tolerance to unresponsiveness for this partner integration
	PartnerUnresponsivenessThresholdInDays *int `json:"partnerUnresponsivenessThresholdInDays,omitempty"`
	// AllowPartnerToCollectIOSApplicationMetadata For IOS devices, allows the admin to configure whether the data sync partner may also collect metadata about installed applications from Intune
	AllowPartnerToCollectIOSApplicationMetadata *bool `json:"allowPartnerToCollectIOSApplicationMetadata,omitempty"`
}
