// Code generated by protoc-gen-go-hrpc. DO NOT EDIT.

package authv1

import (
	bytes "bytes"
	context "context"
	errors "errors"
	proto "google.golang.org/protobuf/proto"
	ioutil "io/ioutil"
	http "net/http"
	httptest "net/http/httptest"
)

type AuthServiceClient interface {
	// Federate with a foreignserver, obtaining a token
	// you can use to call LoginFederated on it
	Federate(context.Context, *FederateRequest) (*FederateResponse, error)
	// Present a token to a foreignserver from a Federate call
	// on your homeserver in order to login
	LoginFederated(context.Context, *LoginFederatedRequest) (*LoginFederatedResponse, error)
	// Returns the public key of this server
	Key(context.Context, *KeyRequest) (*KeyResponse, error)
	// Begins an authentication session
	BeginAuth(context.Context, *BeginAuthRequest) (*BeginAuthResponse, error)
	// Goes to the next step of the authentication session,
	// possibly presenting user input
	NextStep(context.Context, *NextStepRequest) (*NextStepResponse, error)
	// Goes to the previous step of the authentication session
	// if possible
	StepBack(context.Context, *StepBackRequest) (*StepBackResponse, error)
	// Consume the steps of an authentication session
	// as a stream
	StreamSteps(context.Context, chan *StreamStepsRequest) (chan *StreamStepsResponse, error)
	// Check whether or not you're logged in and the session is valid
	CheckLoggedIn(context.Context, *CheckLoggedInRequest) (*CheckLoggedInResponse, error)
}

type HTTPAuthServiceClient struct {
	Client         http.Client
	BaseURL        string
	WebsocketProto string
	WebsocketHost  string
	Header         http.Header
}

func (client *HTTPAuthServiceClient) Federate(req *FederateRequest) (*FederateResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.auth.v1.AuthService/Federate", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &FederateResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPAuthServiceClient) LoginFederated(req *LoginFederatedRequest) (*LoginFederatedResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.auth.v1.AuthService/LoginFederated", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &LoginFederatedResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPAuthServiceClient) Key(req *KeyRequest) (*KeyResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.auth.v1.AuthService/Key", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &KeyResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPAuthServiceClient) BeginAuth(req *BeginAuthRequest) (*BeginAuthResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.auth.v1.AuthService/BeginAuth", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &BeginAuthResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPAuthServiceClient) NextStep(req *NextStepRequest) (*NextStepResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.auth.v1.AuthService/NextStep", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &NextStepResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPAuthServiceClient) StepBack(req *StepBackRequest) (*StepBackResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.auth.v1.AuthService/StepBack", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &StepBackResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPAuthServiceClient) StreamSteps(req *StreamStepsRequest) (chan *StreamStepsResponse, error) {
	return nil, errors.New("unimplemented")
}
func (client *HTTPAuthServiceClient) CheckLoggedIn(req *CheckLoggedInRequest) (*CheckLoggedInResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.auth.v1.AuthService/CheckLoggedIn", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CheckLoggedInResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}

type HTTPTestAuthServiceClient struct {
	Client interface {
		Test(*http.Request, ...int) (*http.Response, error)
	}
}

func (client *HTTPTestAuthServiceClient) Federate(req *FederateRequest) (*FederateResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.auth.v1.AuthService/Federate", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &FederateResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestAuthServiceClient) LoginFederated(req *LoginFederatedRequest) (*LoginFederatedResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.auth.v1.AuthService/LoginFederated", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &LoginFederatedResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestAuthServiceClient) Key(req *KeyRequest) (*KeyResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.auth.v1.AuthService/Key", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &KeyResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestAuthServiceClient) BeginAuth(req *BeginAuthRequest) (*BeginAuthResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.auth.v1.AuthService/BeginAuth", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &BeginAuthResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestAuthServiceClient) NextStep(req *NextStepRequest) (*NextStepResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.auth.v1.AuthService/NextStep", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &NextStepResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestAuthServiceClient) StepBack(req *StepBackRequest) (*StepBackResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.auth.v1.AuthService/StepBack", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &StepBackResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestAuthServiceClient) StreamSteps(req *StreamStepsRequest) (chan *StreamStepsResponse, error) {
	return nil, errors.New("unimplemented")
}
func (client *HTTPTestAuthServiceClient) CheckLoggedIn(req *CheckLoggedInRequest) (*CheckLoggedInResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.auth.v1.AuthService/CheckLoggedIn", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CheckLoggedInResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
