/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.media;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import tim.prune.I18nManager;
import tim.prune.load.ItemToLoad;

public class BlockMultipleMediaDialog
extends JDialog {
    private final ArrayList<String> _domains = new ArrayList();
    private final List<ItemToLoad> _itemsToLoad;

    public BlockMultipleMediaDialog(Frame frame, Set<String> set, List<ItemToLoad> list) {
        super(frame, I18nManager.getText("dialog.loadlinkedmedia.title"), true);
        this.setLocationRelativeTo(frame);
        this._domains.addAll(set);
        Collections.sort(this._domains);
        this._itemsToLoad = list;
        this.getContentPane().add(this.makeContents());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BlockMultipleMediaDialog.this.buttonPressed(ItemToLoad.BlockStatus.ASKED);
            }
        });
        this.pack();
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 4));
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        jPanel.add((Component)new JLabel(String.valueOf(I18nManager.getText("dialog.loadlinkedmedia.blockdomains.desc")) + ":"), "North");
        String[] stringArray = this._domains.toArray(new String[0]);
        JList<String> jList = new JList<String>(stringArray);
        jList.setEnabled(false);
        jPanel.add((Component)new JScrollPane(jList), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 4, 0));
        JButton jButton = new JButton(I18nManager.getText("button.allowall"));
        jButton.addActionListener(actionEvent -> this.buttonPressed(ItemToLoad.BlockStatus.ALLOW));
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.blockall"));
        jButton2.addActionListener(actionEvent -> this.buttonPressed(ItemToLoad.BlockStatus.BLOCK));
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(I18nManager.getText("button.chooseindividually"));
        jButton3.addActionListener(actionEvent -> this.buttonPressed(ItemToLoad.BlockStatus.ASKED));
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void buttonPressed(ItemToLoad.BlockStatus blockStatus) {
        for (ItemToLoad itemToLoad : this._itemsToLoad) {
            if (itemToLoad.getBlockStatus() != ItemToLoad.BlockStatus.NOT_ASKED) continue;
            itemToLoad.setBlockStatus(blockStatus);
        }
        this.dispose();
    }
}

