/*
    This file is part of the Kushview Modules for JUCE
    Copyright (c) 2014-2019  Kushview, LLC.  All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma once

/** Commonly used Identifiers, these might represent different things depending
    on the context of use */
namespace Slugs {

    static const Identifier asset    = "asset";
    static const Identifier assetId  = "assetId";
    static const Identifier attack   = "attack";
    static const Identifier block    = "block";
    static const Identifier bpm      = "bpm";
    static const Identifier category = "category";
    static const Identifier channel  = "channel";
    static const Identifier clip     = "clip";
    static const Identifier decay    = "decay";
    static const Identifier file     = "file";
    static const Identifier fsid     = "fsid";
    static const Identifier events   = "events";
    static const Identifier graph    = "graph";
    static const Identifier group    = "group";
    static const Identifier id       = "id";
    static const Identifier index    = "index";
    static const Identifier keyId    = "keyId";
    static const Identifier length   = "length";
    static const Identifier media    = "media";
    static const Identifier name     = "name";
    static const Identifier nodeId   = "nodeId";
    static const Identifier note     = "note";
    static const Identifier offset   = "offset";
    static const Identifier path     = "path";
    static const Identifier pattern  = "pattern";
    static const Identifier parent   = "parent";
    static const Identifier pitch    = "pitch";
    static const Identifier ppq      = "ppq";
    static const Identifier release  = "release";
    static const Identifier sampler  = "sampler";
    static const Identifier sequence = "sequence";
    static const Identifier start    = "start";
    static const Identifier sustain  = "sustain";
    static const Identifier tempo    = "tempo";
    static const Identifier track    = "track";
    static const Identifier type     = "type";
    static const Identifier velocity = "velocity";
    static const Identifier version  = "version";
    static const Identifier volume   = "volume";
    static const Identifier dock     = "dock";
    static const Identifier panel    = "panel";
    static const Identifier item     = "item";
    static const Identifier area     = "area";
    static const Identifier vertical = "vertical";
    static const Identifier bounds   = "bounds";
    static const Identifier barSize  = "barSize";
    static const Identifier sizes    = "sizes";
}
