#!/bin/bash

MAJOR_VERSION=`bash ./bashrun --major-version`
MINOR_VERSION=`bash ./bashrun --minor-version`
BUGFIX_VERSION=`bash ./bashrun --bugfix-version`
VERSION="$MAJOR_VERSION.$MINOR_VERSION"

PREFIX=/usr/local
if [[ "$1" =~ ^--prefix=.+ ]]; then
    PREFIX=$(echo $1 | cut -d = -f 2)
    PREFIX=${PREFIX:-/usr/local}
fi

install -v -d $PREFIX/bin
install -v -m 755 bashrun $PREFIX/bin

install -v -d $PREFIX/share/bashrun
install -v -m 644 bashrc $PREFIX/share/bashrun

install -v -d $PREFIX/share/man/man1
install -v -m 644 bashrun.1 $PREFIX/share/man/man1

echo
echo -e "\033[1;32mbashrun $VERSION has been installed in $PREFIX\033[0m

\033[1;37mUsers upgrading from versions <= 0.6\033[0m will need to
delete or rename their user configuration file due to substantial
changes in the configuration file format and handling.

\033[1;37mFor users upgrading from versions >= 0.7\033[0m, removing the
configuration file is not strictly required, although it is
recommended to easily add the new configuration options to your
configuration file. Also, the default settings described in the manual
page may differ from your configuration if you chose not to let
bashrun recreate your configuration file.
"