/*
 *  provide.c
 * 
 *  Copyright (c) 2002-2006 by Judd Vinet <jvinet@zeroflux.org>
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "config.h"

#include <stdlib.h>
#include <string.h>

/* libalpm */
#include "provide.h"
#include "alpm_list.h"
#include "cache.h"
#include "db.h"
#include "log.h"

/* return a alpm_list_t of packages in "db" that provide "package"
 */
alpm_list_t *_alpm_db_whatprovides(pmdb_t *db, const char *package)
{
	alpm_list_t *pkgs = NULL;
	alpm_list_t *lp;

	ALPM_LOG_FUNC;

	if(db == NULL || package == NULL || strlen(package) == 0) {
		return(NULL);
	}

	for(lp = _alpm_db_get_pkgcache(db); lp; lp = lp->next) {
		pmpkg_t *info = lp->data;

		if(alpm_list_find_str(alpm_pkg_get_provides(info), package)) {
			pkgs = alpm_list_add(pkgs, info);
		}
	}

	return(pkgs);
}

/* vim: set ts=2 sw=2 noet: */
