#include "alaw.h"

// alaw -> signed 16-bit 
static short alaw_to_lin[] = {
	0x13fc, 0xec04, 0x0144, 0xfebc, 0x517c, 0xae84, 0x051c, 0xfae4,
	0x0a3c, 0xf5c4, 0x0048, 0xffb8, 0x287c, 0xd784, 0x028c, 0xfd74,
	0x1bfc, 0xe404, 0x01cc, 0xfe34, 0x717c, 0x8e84, 0x071c, 0xf8e4,
	0x0e3c, 0xf1c4, 0x00c4, 0xff3c, 0x387c, 0xc784, 0x039c, 0xfc64,
	0x0ffc, 0xf004, 0x0104, 0xfefc, 0x417c, 0xbe84, 0x041c, 0xfbe4,
	0x083c, 0xf7c4, 0x0008, 0xfff8, 0x207c, 0xdf84, 0x020c, 0xfdf4,
	0x17fc, 0xe804, 0x018c, 0xfe74, 0x617c, 0x9e84, 0x061c, 0xf9e4,
	0x0c3c, 0xf3c4, 0x0084, 0xff7c, 0x307c, 0xcf84, 0x030c, 0xfcf4,
	0x15fc, 0xea04, 0x0164, 0xfe9c, 0x597c, 0xa684, 0x059c, 0xfa64,
	0x0b3c, 0xf4c4, 0x0068, 0xff98, 0x2c7c, 0xd384, 0x02cc, 0xfd34,
	0x1dfc, 0xe204, 0x01ec, 0xfe14, 0x797c, 0x8684, 0x07bc, 0xf844,
	0x0f3c, 0xf0c4, 0x00e4, 0xff1c, 0x3c7c, 0xc384, 0x03dc, 0xfc24,
	0x11fc, 0xee04, 0x0124, 0xfedc, 0x497c, 0xb684, 0x049c, 0xfb64,
	0x093c, 0xf6c4, 0x0028, 0xffd8, 0x247c, 0xdb84, 0x024c, 0xfdb4,
	0x19fc, 0xe604, 0x01ac, 0xfe54, 0x697c, 0x9684, 0x069c, 0xf964,
	0x0d3c, 0xf2c4, 0x00a4, 0xff5c, 0x347c, 0xcb84, 0x034c, 0xfcb4,
	0x12fc, 0xed04, 0x0134, 0xfecc, 0x4d7c, 0xb284, 0x04dc, 0xfb24,
	0x09bc, 0xf644, 0x0038, 0xffc8, 0x267c, 0xd984, 0x026c, 0xfd94,
	0x1afc, 0xe504, 0x01ac, 0xfe54, 0x6d7c, 0x9284, 0x06dc, 0xf924,
	0x0dbc, 0xf244, 0x00b4, 0xff4c, 0x367c, 0xc984, 0x036c, 0xfc94,
	0x0f3c, 0xf0c4, 0x00f4, 0xff0c, 0x3e7c, 0xc184, 0x03dc, 0xfc24,
	0x07bc, 0xf844, 0x0008, 0xfff8, 0x1efc, 0xe104, 0x01ec, 0xfe14,
	0x16fc, 0xe904, 0x0174, 0xfe8c, 0x5d7c, 0xa284, 0x05dc, 0xfa24,
	0x0bbc, 0xf444, 0x0078, 0xff88, 0x2e7c, 0xd184, 0x02ec, 0xfd14,
	0x14fc, 0xeb04, 0x0154, 0xfeac, 0x557c, 0xaa84, 0x055c, 0xfaa4,
	0x0abc, 0xf544, 0x0058, 0xffa8, 0x2a7c, 0xd584, 0x02ac, 0xfd54,
	0x1cfc, 0xe304, 0x01cc, 0xfe34, 0x757c, 0x8a84, 0x075c, 0xf8a4,
	0x0ebc, 0xf144, 0x00d4, 0xff2c, 0x3a7c, 0xc584, 0x039c, 0xfc64,
	0x10fc, 0xef04, 0x0114, 0xfeec, 0x457c, 0xba84, 0x045c, 0xfba4,
	0x08bc, 0xf744, 0x0018, 0xffe8, 0x227c, 0xdd84, 0x022c, 0xfdd4,
	0x18fc, 0xe704, 0x018c, 0xfe74, 0x657c, 0x9a84, 0x065c, 0xf9a4,
	0x0cbc, 0xf344, 0x0094, 0xff6c, 0x327c, 0xcd84, 0x032c, 0xfcd4
};

static unsigned char linear2alaw(short sample)
{
	int best = -1;
	int i = 0;
	int diff = 0;
	int best_diff = 0;

	while (i < 256) {
		diff = alaw_to_lin[i] - sample;

		if (diff < 0)
			diff = 0 - diff;

		if (diff < best_diff || best < 0) {
			best_diff = diff;
			best = i;
		}

		i++;
	}

	return (best);
}

static int alaw2linear(unsigned char sample)
{
	signed short r = 0, sign = 1;

	// Must reverse bit order.
	sample = ((sample & 0xaaaa) >> 1) | ((sample & 0x5555) << 1);
	sample = ((sample & 0xcccc) >> 2) | ((sample & 0x3333) << 2);
	sample = (sample >> 4) | (sample << 4);
	if (sample & 0x80) {
		sample ^= 0xd5;	// Flip bits for positive values
	} else {
		sample ^= 0x55;	// Flip bits for negative values
		sign = -1;	// Remember sign
	}
	switch (sample & 0x70) {
	case 0x70:		// Segment 7 (0x800..0xfff)
		r = 0x840 | ((sample & 0xf) << 7);
		break;
	case 0x60:		// Segment 6 (0x400..0x7ff)
		r = 0x420 | ((sample & 0xf) << 6);
		break;
	case 0x50:		// Segment 5 (0x200..0x3ff)
		r = 0x210 | ((sample & 0xf) << 5);
		break;
	case 0x40:		// Segment 4 (0x100..0x1ff)
		r = 0x108 | ((sample & 0xf) << 4);
		break;
	case 0x30:		// Segment 3 (0x080..0x0ff)
		r = 0x084 | ((sample & 0xf) << 3);
		break;
	case 0x20:		// Segment 2 (0x040..0x07f)
		r = 0x042 | ((sample & 0xf) << 2);
		break;
	default:		// Segment 1 (0x000..0x03f)
		r = 0x001 | ((sample & 0x1f) << 1);
	}
	return (r * sign) << 3;
}

// Build table .. makes encoding pretty fast :)
void create_lin2alaw_table(void)
{
	int i;

	slin2alaw = &lin2alaw[32768];

	// build law->linear16
	for (i = 0; i < 65535; i++)
		slin2alaw[i - 32768] = linear2alaw((short)i - 32768);

	// build linear16->law    
	for (i = 0; i < 256; i++) {
		alaw2lin[i] = alaw2linear((unsigned char)i);
	}
}
